/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.trees.ft.FTInnerNode;
import weka.classifiers.trees.ft.FTLeavesNode;
import weka.classifiers.trees.ft.FTNode;
import weka.classifiers.trees.ft.FTtree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class FT
extends Classifier
implements OptionHandler,
AdditionalMeasureProducer,
Drawable,
TechnicalInformationHandler {
    static final long serialVersionUID = -1113212459618105000L;
    protected ReplaceMissingValues m_replaceMissing;
    protected NominalToBinary m_nominalToBinary;
    protected FTtree m_tree;
    protected boolean m_convertNominal;
    protected boolean m_errorOnProbabilities;
    protected int m_minNumInstances = 15;
    protected int m_numBoostingIterations = 15;
    protected int m_modelType = 0;
    protected double m_weightTrimBeta = 0.0;
    protected boolean m_useAIC = false;
    public static final int MODEL_FT = 0;
    public static final int MODEL_FTLeaves = 1;
    public static final int MODEL_FTInner = 2;
    public static final Tag[] TAGS_MODEL = new Tag[]{new Tag(0, "FT"), new Tag(1, "FTLeaves"), new Tag(2, "FTInner")};

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        Instances filteredData = new Instances(data);
        filteredData.deleteWithMissingClass();
        this.m_replaceMissing = new ReplaceMissingValues();
        this.m_replaceMissing.setInputFormat(filteredData);
        filteredData = Filter.useFilter(filteredData, this.m_replaceMissing);
        if (this.m_convertNominal) {
            this.m_nominalToBinary = new NominalToBinary();
            this.m_nominalToBinary.setInputFormat(filteredData);
            filteredData = Filter.useFilter(filteredData, this.m_nominalToBinary);
        }
        int minNumInstances = 2;
        if (this.m_modelType == 0) {
            this.m_tree = new FTNode(this.m_errorOnProbabilities, this.m_numBoostingIterations, this.m_minNumInstances, this.m_weightTrimBeta, this.m_useAIC);
        }
        if (this.m_modelType == 1) {
            this.m_tree = new FTLeavesNode(this.m_errorOnProbabilities, this.m_numBoostingIterations, this.m_minNumInstances, this.m_weightTrimBeta, this.m_useAIC);
        }
        if (this.m_modelType == 2) {
            this.m_tree = new FTInnerNode(this.m_errorOnProbabilities, this.m_numBoostingIterations, this.m_minNumInstances, this.m_weightTrimBeta, this.m_useAIC);
        }
        this.m_tree.buildClassifier(filteredData);
        this.m_tree.prune();
        this.m_tree.assignIDs(0);
        this.m_tree.cleanup();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_replaceMissing.input(instance);
        instance = this.m_replaceMissing.output();
        if (this.m_convertNominal) {
            this.m_nominalToBinary.input(instance);
            instance = this.m_nominalToBinary.output();
        }
        return this.m_tree.distributionForInstance(instance);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double maxProb = -1.0;
        int maxIndex = 0;
        double[] probs = this.distributionForInstance(instance);
        int j = 0;
        while (j < instance.numClasses()) {
            if (Utils.gr(probs[j], maxProb)) {
                maxIndex = j;
                maxProb = probs[j];
            }
            ++j;
        }
        return maxIndex;
    }

    public String toString() {
        if (this.m_tree != null) {
            if (this.m_modelType == 0) {
                return "FT tree \n------------------\n" + this.m_tree.toString();
            }
            if (this.m_modelType == 1) {
                return "FT Leaves tree \n------------------\n" + this.m_tree.toString();
            }
            return "FT Inner tree \n------------------\n" + this.m_tree.toString();
        }
        return "No tree built";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(8);
        newVector.addElement(new Option("\tBinary splits (convert nominal attributes to binary ones) ", "B", 0, "-B"));
        newVector.addElement(new Option("\tUse error on probabilities instead of misclassification error for stopping criterion of LogitBoost.", "P", 0, "-P"));
        newVector.addElement(new Option("\tSet fixed number of iterations for LogitBoost (instead of using cross-validation)", "I", 1, "-I <numIterations>"));
        newVector.addElement(new Option("\tSet Funtional Tree type to be generate:  0 for FT, 1 for FTLeaves and 2 for FTInner", "F", 1, "-F <modelType>"));
        newVector.addElement(new Option("\tSet minimum number of instances at which a node can be split (default 15)", "M", 1, "-M <numInstances>"));
        newVector.addElement(new Option("\tSet beta for weight trimming for LogitBoost. Set to 0 (default) for no weight trimming.", "W", 1, "-W <beta>"));
        newVector.addElement(new Option("\tThe AIC is used to choose the best iteration.", "A", 0, "-A"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setBinSplit(Utils.getFlag('B', options));
        this.setErrorOnProbabilities(Utils.getFlag('P', options));
        String optionString = Utils.getOption('I', options);
        if (optionString.length() != 0) {
            this.setNumBoostingIterations(new Integer(optionString));
        }
        if ((optionString = Utils.getOption('F', options)).length() != 0) {
            this.setModelType(new SelectedTag(Integer.parseInt(optionString), TAGS_MODEL));
        }
        if ((optionString = Utils.getOption('M', options)).length() != 0) {
            this.setMinNumInstances(new Integer(optionString));
        }
        if ((optionString = Utils.getOption('W', options)).length() != 0) {
            this.setWeightTrimBeta(new Double(optionString));
        }
        this.setUseAIC(Utils.getFlag('A', options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[11];
        int current = 0;
        if (this.getBinSplit()) {
            options[current++] = "-B";
        }
        if (this.getErrorOnProbabilities()) {
            options[current++] = "-P";
        }
        options[current++] = "-I";
        options[current++] = "" + this.getNumBoostingIterations();
        options[current++] = "-F";
        options[current++] = "" + this.getModelType().getSelectedTag().getID();
        options[current++] = "-M";
        options[current++] = "" + this.getMinNumInstances();
        options[current++] = "-W";
        options[current++] = "" + this.getWeightTrimBeta();
        if (this.getUseAIC()) {
            options[current++] = "-A";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public double getWeightTrimBeta() {
        return this.m_weightTrimBeta;
    }

    public boolean getUseAIC() {
        return this.m_useAIC;
    }

    public void setWeightTrimBeta(double n) {
        this.m_weightTrimBeta = n;
    }

    public void setUseAIC(boolean c) {
        this.m_useAIC = c;
    }

    public boolean getBinSplit() {
        return this.m_convertNominal;
    }

    public boolean getErrorOnProbabilities() {
        return this.m_errorOnProbabilities;
    }

    public int getNumBoostingIterations() {
        return this.m_numBoostingIterations;
    }

    public SelectedTag getModelType() {
        return new SelectedTag(this.m_modelType, TAGS_MODEL);
    }

    public void setModelType(SelectedTag newMethod) {
        if (newMethod.getTags() == TAGS_MODEL) {
            int c = newMethod.getSelectedTag().getID();
            if (c == 0 || c == 1 || c == 2) {
                this.m_modelType = c;
            } else {
                throw new IllegalArgumentException("Wrong model type, -F value should be: 0, for FT, 1, for FTLeaves, and 2, for FTInner ");
            }
        }
    }

    public int getMinNumInstances() {
        return this.m_minNumInstances;
    }

    public void setBinSplit(boolean c) {
        this.m_convertNominal = c;
    }

    public void setErrorOnProbabilities(boolean c) {
        this.m_errorOnProbabilities = c;
    }

    public void setNumBoostingIterations(int c) {
        this.m_numBoostingIterations = c;
    }

    public void setMinNumInstances(int c) {
        this.m_minNumInstances = c;
    }

    @Override
    public int graphType() {
        return 1;
    }

    @Override
    public String graph() throws Exception {
        return this.m_tree.graph();
    }

    public int measureTreeSize() {
        return this.m_tree.numNodes();
    }

    public int measureNumLeaves() {
        return this.m_tree.numLeaves();
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(2);
        newVector.addElement("measureTreeSize");
        newVector.addElement("measureNumLeaves");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(String.valueOf(additionalMeasureName) + " not supported (FT)");
    }

    public String globalInfo() {
        return "Classifier for building 'Functional trees', which are classification trees  that could have logistic regression functions at the inner nodes and/or leaves. The algorithm can deal with binary and multi-class target variables, numeric and nominal attributes and missing values.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Joao Gama");
        result.setValue(TechnicalInformation.Field.TITLE, "Functional Trees");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.VOLUME, "55");
        result.setValue(TechnicalInformation.Field.PAGES, "219-250");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Niels Landwehr and Mark Hall and Eibe Frank");
        additional.setValue(TechnicalInformation.Field.TITLE, "Logistic Model Trees");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Machine Learning");
        additional.setValue(TechnicalInformation.Field.YEAR, "2005");
        additional.setValue(TechnicalInformation.Field.VOLUME, "95");
        additional.setValue(TechnicalInformation.Field.PAGES, "161-205");
        additional.setValue(TechnicalInformation.Field.NUMBER, "1-2");
        return result;
    }

    public String modelTypeTipText() {
        return "The type of FT model. 0, for FT, 1, for FTLeaves, and 2, for FTInner";
    }

    public String binSplitTipText() {
        return "Convert all nominal attributes to binary ones before building the tree. This means that all splits in the final tree will be binary.";
    }

    public String errorOnProbabilitiesTipText() {
        return "Minimize error on probabilities instead of misclassification error when cross-validating the number of LogitBoost iterations. When set, the number of LogitBoost iterations is chosen that minimizes the root mean squared error instead of the misclassification error.";
    }

    public String numBoostingIterationsTipText() {
        return "Set a fixed number of iterations for LogitBoost. If >= 0, this sets a fixed number of LogitBoost iterations that is used everywhere in the tree. If < 0, the number is cross-validated.";
    }

    public String minNumInstancesTipText() {
        return "Set the minimum number of instances at which a node is considered for splitting. The default value is 15.";
    }

    public String weightTrimBetaTipText() {
        return "Set the beta value used for weight trimming in LogitBoost. Only instances carrying (1 - beta)% of the weight from previous iteration are used in the next iteration. Set to 0 for no weight trimming. The default value is 0.";
    }

    public String useAICTipText() {
        return "The AIC is used to determine when to stop LogitBoost iterations. The default is not to use AIC.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    public static void main(String[] argv) {
        FT.runClassifier(new FT(), argv);
    }
}

