/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Version
implements Comparable,
RevisionHandler {
    public static final String VERSION_FILE = "weka/core/version.txt";
    public static int MAJOR = 3;
    public static int MINOR = 4;
    public static int REVISION = 3;
    public static boolean SNAPSHOT = false;
    protected static final String SNAPSHOT_STRING = "-SNAPSHOT";
    public static String VERSION;

    static {
        try {
            InputStream inR = new Version().getClass().getClassLoader().getResourceAsStream(VERSION_FILE);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inR));
            String line = lnr.readLine();
            int[] maj = new int[1];
            int[] min = new int[1];
            int[] rev = new int[1];
            SNAPSHOT = Version.parseVersion(line, maj, min, rev);
            MAJOR = maj[0];
            MINOR = min[0];
            REVISION = rev[0];
            lnr.close();
        }
        catch (Exception e) {
            System.err.println(String.valueOf(Version.class.getName()) + ": Unable to load version information!");
        }
        VERSION = String.valueOf(MAJOR) + "." + MINOR + "." + REVISION + (SNAPSHOT ? SNAPSHOT_STRING : "");
    }

    private static boolean parseVersion(String version, int[] maj, int[] min, int[] rev) {
        boolean isSnapshot;
        block10: {
            int major = 0;
            int minor = 0;
            int revision = 0;
            isSnapshot = false;
            try {
                try {
                    String tmpStr = version;
                    if (tmpStr.toLowerCase().endsWith("-snapshot")) {
                        tmpStr = tmpStr.substring(0, tmpStr.toLowerCase().indexOf("-snapshot"));
                        isSnapshot = true;
                    }
                    if ((tmpStr = tmpStr.replace('-', '.')).indexOf(".") > -1) {
                        major = Integer.parseInt(tmpStr.substring(0, tmpStr.indexOf(".")));
                        if ((tmpStr = tmpStr.substring(tmpStr.indexOf(".") + 1)).indexOf(".") > -1) {
                            minor = Integer.parseInt(tmpStr.substring(0, tmpStr.indexOf(".")));
                            revision = !(tmpStr = tmpStr.substring(tmpStr.indexOf(".") + 1)).equals("") ? Integer.parseInt(tmpStr) : 0;
                        } else {
                            minor = !tmpStr.equals("") ? Integer.parseInt(tmpStr) : 0;
                        }
                        break block10;
                    }
                    if (!tmpStr.equals("")) {
                        major = Integer.parseInt(tmpStr);
                        break block10;
                    }
                    major = 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    major = -1;
                    minor = -1;
                    revision = -1;
                    maj[0] = major;
                    min[0] = minor;
                    rev[0] = revision;
                }
            }
            finally {
                maj[0] = major;
                min[0] = minor;
                rev[0] = revision;
            }
        }
        return isSnapshot;
    }

    public int compareTo(Object o) {
        int revision;
        int minor;
        int major;
        int[] maj = new int[1];
        int[] min = new int[1];
        int[] rev = new int[1];
        if (o instanceof String) {
            Version.parseVersion((String)o, maj, min, rev);
            major = maj[0];
            minor = min[0];
            revision = rev[0];
        } else {
            System.out.println(String.valueOf(this.getClass().getName()) + ": no version-string for comparTo povided!");
            major = -1;
            minor = -1;
            revision = -1;
        }
        int result = MAJOR < major ? -1 : (MAJOR == major ? (MINOR < minor ? -1 : (MINOR == minor ? (REVISION < revision ? -1 : (REVISION == revision ? 0 : 1)) : 1)) : 1);
        return result;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public boolean isOlder(Object o) {
        return this.compareTo(o) == -1;
    }

    public boolean isNewer(Object o) {
        return this.compareTo(o) == 1;
    }

    public String toString() {
        return VERSION;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] args) {
        System.out.println(String.valueOf(VERSION) + "\n");
        Version v = new Version();
        System.out.println("-1? " + v.compareTo("5.0.1"));
        System.out.println(" 0? " + v.compareTo(VERSION));
        System.out.println("+1? " + v.compareTo("3.4.0"));
        String tmpStr = "5.0.1";
        System.out.println("\ncomparing with " + tmpStr);
        System.out.println("isOlder? " + v.isOlder(tmpStr));
        System.out.println("equals ? " + v.equals(tmpStr));
        System.out.println("isNewer? " + v.isNewer(tmpStr));
        tmpStr = VERSION;
        System.out.println("\ncomparing with " + tmpStr);
        System.out.println("isOlder? " + v.isOlder(tmpStr));
        System.out.println("equals ? " + v.equals(tmpStr));
        System.out.println("isNewer? " + v.isNewer(tmpStr));
        tmpStr = "3.4.0";
        System.out.println("\ncomparing with " + tmpStr);
        System.out.println("isOlder? " + v.isOlder(tmpStr));
        System.out.println("equals ? " + v.equals(tmpStr));
        System.out.println("isNewer? " + v.isNewer(tmpStr));
        tmpStr = "3.4";
        System.out.println("\ncomparing with " + tmpStr);
        System.out.println("isOlder? " + v.isOlder(tmpStr));
        System.out.println("equals ? " + v.equals(tmpStr));
        System.out.println("isNewer? " + v.isNewer(tmpStr));
        tmpStr = "5";
        System.out.println("\ncomparing with " + tmpStr);
        System.out.println("isOlder? " + v.isOlder(tmpStr));
        System.out.println("equals ? " + v.equals(tmpStr));
        System.out.println("isNewer? " + v.isNewer(tmpStr));
    }
}

