/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.experiment.ExperimentParams;
import java.util.Properties;

public final class MCFSParams
extends ExperimentParams {
    public static String FILESUFIX_IMPORTANCES = "RI.csv";
    public static String FILESUFIX_CONNECTIONS = "ID.csv";
    public static String FILESUFIX_TOPRANKING = "topRanking.csv";
    public static String FILESUFIX_DISTANCE = "distances.csv";
    public static String FILESUFIX_MATRIX = "cmatrix.csv";
    public static String FILESUFIX_CUTOFF = "cutoff.csv";
    public static String FILESUFIX_CV_RESULT = "cv_accuracy.csv";
    public static String FILESUFIX_PERMUTATIONS = "permutations.csv";
    public static String FILESUFIX_RULESET = "jrip.txt";
    public static String CONTRAST_ATTR_NAME = "contrast_attr_";
    private static String[] CUTOFF_METHODS = new String[]{"mean", "criticalAngle", "kmeans", "permutations", "contrastAttributes"};
    public long seed;
    public boolean progressShow;
    public int progressInterval;
    public int threadsNumber = 8;
    public int classifier;
    public int projections;
    public float projectionSize;
    public int projectionSizeAttr = -1;
    public int splits;
    public float splitRatio;
    public float balanceRatio;
    public int splitSetSize;
    public boolean buildID = true;
    public boolean finalRuleset = true;
    public boolean finalCV = true;
    public int finalCVSetSize = 1000;
    public int finalCVRepetitions = 3;
    public int foldsCV = 10;
    public float u;
    public float v;
    public int cutoffPermutations = 20;
    public float cutoffAlpha;
    public float cutoffAngle;
    public String cutoffMethod;
    public boolean contrastAttr = false;
    public int contrastAttrThreshold;
    public int wekaClassifierMode;
    public boolean useGainRatio;
    public int maxConnectionDepth;
    public int qMethod;
    public boolean useComplexQuality;
    public boolean useDiversityMeasure;

    public MCFSParams() {
        this.setDefault();
    }

    @Override
    public final boolean setDefault() {
        super.setDefault();
        this.label = "MCFS";
        this.inputFilesPATH = DEFAULT_DATA_PATH;
        this.resFilesPATH = DEFAULT_RES_PATH;
        this.verbose = false;
        this.debug = false;
        this.inputFileName = "";
        this.testFileName = null;
        this.outputFileName = null;
        this.seed = System.currentTimeMillis();
        this.threadsNumber = 8;
        this.progressInterval = 10;
        this.progressShow = true;
        this.classifier = Classifier.J48;
        this.projections = 2000;
        this.projectionSize = 0.05f;
        this.splits = 5;
        this.splitRatio = 0.66f;
        this.balanceRatio = 1.0f;
        this.splitSetSize = 1000;
        this.u = 1.0f;
        this.v = 1.0f;
        this.buildID = true;
        this.finalRuleset = true;
        this.finalCV = true;
        this.finalCVSetSize = 1000;
        this.finalCVRepetitions = 3;
        this.cutoffPermutations = 20;
        this.cutoffAlpha = 0.05f;
        this.contrastAttr = false;
        this.contrastAttrThreshold = 5;
        this.cutoffAngle = 0.01f;
        this.cutoffMethod = "mean";
        this.maxConnectionDepth = 5;
        this.useGainRatio = true;
        this.qMethod = 2;
        this.useComplexQuality = true;
        this.useDiversityMeasure = true;
        this.wekaClassifierMode = 0;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(super.toString()).append('\n');
        tmp.append("### MCFS Parameters ### \n");
        tmp.append("mcfs.projections = " + this.projections).append('\n');
        tmp.append("mcfs.projectionSize = " + this.projectionSize).append('\n');
        tmp.append("mcfs.splits = " + this.splits).append('\n');
        tmp.append("mcfs.splitRatio = " + this.splitRatio).append('\n');
        tmp.append("mcfs.balanceRatio = " + this.balanceRatio).append('\n');
        tmp.append("mcfs.splitSetSize = " + this.splitSetSize).append('\n');
        tmp.append("mcfs.contrastAttr = " + this.contrastAttr).append('\n');
        tmp.append("mcfs.contrastAttrThreshold = " + this.contrastAttrThreshold).append('\n');
        tmp.append("mcfs.cutoffPermutations = " + this.cutoffPermutations).append('\n');
        tmp.append("mcfs.cutoffAlpha = " + this.cutoffAlpha).append('\n');
        tmp.append("mcfs.cutoffAngle = " + this.cutoffAngle).append('\n');
        tmp.append("mcfs.cutoffMethod = " + this.cutoffMethod).append('\n');
        tmp.append("mcfs.buildID = " + this.buildID).append('\n');
        tmp.append("mcfs.finalRuleset = " + this.finalRuleset).append('\n');
        tmp.append("mcfs.finalCV = " + this.finalCV).append('\n');
        tmp.append("mcfs.finalCVSetSize = " + this.finalCVSetSize).append('\n');
        tmp.append("mcfs.finalCVRepetitions = " + this.finalCVRepetitions).append('\n');
        tmp.append("mcfs.u = " + this.u).append('\n');
        tmp.append("mcfs.v = " + this.v).append('\n');
        tmp.append('\n');
        tmp.append("mcfs.threadsNumber = " + this.threadsNumber).append('\n');
        tmp.append("mcfs.showDistanceProgress = " + this.progressShow).append('\n');
        tmp.append("mcfs.progressInterval = " + this.progressInterval).append('\n');
        tmp.append("mcfs.classifier = " + Classifier.int2label(this.classifier)).append('\n');
        tmp.append("mcfs.seed = " + this.seed).append('\n');
        tmp.append("j48.useGainRatio = " + this.useGainRatio).append('\n');
        tmp.append("j48.maxConnectionDepth = " + this.maxConnectionDepth).append('\n');
        tmp.append("adx.useComplexQuality = " + this.useComplexQuality).append('\n');
        tmp.append("adx.qMethod = " + this.qMethod).append('\n');
        tmp.append("sliq.useDiversityMeasure = " + this.useDiversityMeasure).append('\n');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean update(Properties properties) {
        void var1_1;
        void var2_2;
        if (!super.update(properties)) {
            return false;
        }
        this.testFileName = null;
        this.outputFileName = null;
        this.progressShow = Boolean.valueOf(properties.getProperty("mcfs.progressShow", "true"));
        this.threadsNumber = Integer.valueOf(properties.getProperty("mcfs.threadsNumber", "8"));
        this.classifier = Classifier.label2int(properties.getProperty("mcfs.classifier", "j48"));
        this.progressInterval = Integer.valueOf(properties.getProperty("mcfs.progressInterval", "10"));
        String seedProp = properties.getProperty("mcfs.seed", "");
        this.seed = seedProp.trim().length() == 0 ? System.currentTimeMillis() : (long)Long.valueOf((String)var2_2).intValue();
        this.projections = Integer.valueOf(properties.getProperty("mcfs.projections", "1000"));
        this.projectionSize = Float.valueOf(properties.getProperty("mcfs.projectionSize", "0.1")).floatValue();
        this.splits = Integer.valueOf(properties.getProperty("mcfs.splits", "10"));
        this.splitRatio = Float.valueOf(properties.getProperty("mcfs.splitRatio", "0.66")).floatValue();
        this.balanceRatio = Float.valueOf(properties.getProperty("mcfs.balanceRatio", "1")).floatValue();
        this.splitSetSize = Float.valueOf(properties.getProperty("mcfs.splitSetSize", "1000")).intValue();
        this.cutoffMethod = properties.getProperty("mcfs.cutoffMethod", "mean");
        this.buildID = Boolean.valueOf(properties.getProperty("mcfs.buildID", "true"));
        this.finalRuleset = Boolean.valueOf(properties.getProperty("mcfs.finalRuleset", "true"));
        this.finalCV = Boolean.valueOf(properties.getProperty("mcfs.finalCV", "true"));
        this.finalCVSetSize = Integer.valueOf(properties.getProperty("mcfs.finalCVSetSize", "1000"));
        this.finalCVRepetitions = Integer.valueOf(properties.getProperty("mcfs.finalCVRepetitions", "3"));
        this.u = Float.valueOf(properties.getProperty("mcfs.u", "1")).floatValue();
        this.v = Float.valueOf(properties.getProperty("mcfs.v", "1")).floatValue();
        this.contrastAttr = Boolean.valueOf(properties.getProperty("mcfs.contrastAttr", "false"));
        this.contrastAttrThreshold = Integer.valueOf(properties.getProperty("mcfs.contrastAttrThreshold", "5"));
        this.cutoffAngle = Float.valueOf(properties.getProperty("mcfs.cutoffAngle", "0.01")).floatValue();
        this.cutoffPermutations = Integer.valueOf(properties.getProperty("mcfs.cutoffPermutations", "25"));
        this.cutoffAlpha = Float.valueOf(properties.getProperty("mcfs.cutoffAlpha", "0.05")).floatValue();
        this.useGainRatio = Boolean.valueOf(properties.getProperty("j48.useGainRatio", "true"));
        this.maxConnectionDepth = Integer.valueOf(properties.getProperty("j48.maxConnectionDepth", "3"));
        this.qMethod = Integer.valueOf(properties.getProperty("adx.qMethod", "2"));
        this.useComplexQuality = Boolean.valueOf(properties.getProperty("adx.useComplexQuality", "true"));
        this.useDiversityMeasure = Boolean.valueOf(var1_1.getProperty("sliq.useDiversityMeasure", "true"));
        return true;
    }

    @Override
    public final boolean check(FArray array) {
        if (!super.check(array)) {
            return false;
        }
        if (this.splits <= 0) {
            System.err.println("Error! Incorrect value of splits: " + this.splits);
            return false;
        }
        if (this.projections <= 0) {
            System.err.println("Error! Incorrect value of projections: " + this.projections);
            return false;
        }
        if (this.projectionSize <= 0.0f) {
            System.err.println("Error! Incorrect value of projectionSize: " + this.projectionSize);
            return false;
        }
        if (this.splitRatio <= 0.0f || this.splitRatio >= 1.0f) {
            System.err.println("Error! Incorrect value of splitRatio: " + this.splitRatio);
            return false;
        }
        if (this.balanceRatio < 0.0f) {
            System.err.println("Error! Incorrect value of balanceRatio: " + this.balanceRatio);
            return false;
        }
        if (this.cutoffPermutations < 0) {
            System.err.println("Error! Incorrect value of cutoffPermutations: " + this.cutoffPermutations);
            return false;
        }
        if (this.cutoffAlpha <= 0.0f) {
            System.err.println("Error! Incorrect value of cutPointAlpha: " + this.cutoffAlpha);
            return false;
        }
        if (this.classifier != Classifier.RND && this.classifier != Classifier.J48 && this.classifier != Classifier.ADX && this.classifier != Classifier.SLIQ) {
            System.err.println("Error! Incorrect value of classifier:" + this.classifier);
            return false;
        }
        if (array != null) {
            boolean bl;
            MCFSParams mCFSParams;
            int n = ((FArray)((Object)mCFSParams)).attributes.length;
            mCFSParams = this;
            this.projectionSizeAttr = (int)mCFSParams.projectionSize;
            if (mCFSParams.projectionSize <= 1.0f) {
                mCFSParams.projectionSizeAttr = (int)((float)n * mCFSParams.projectionSize);
            }
            if (mCFSParams.projectionSizeAttr >= n) {
                System.err.println("Error parameters! projectionSizeAttr >= number of attributes");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return false;
            }
        }
        if (!DiscFunctions.stringsEquals(this.cutoffMethod, CUTOFF_METHODS)) {
            System.out.println("Warrning! Incorrect value of cutoffMethod:'" + this.cutoffMethod + "'. Replaced by 'mean'");
            this.cutoffMethod = "mean";
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final MCFSParams clone() {
        void var1_1;
        MCFSParams p = new MCFSParams();
        MCFSParams mCFSParams = this;
        MCFSParams mCFSParams2 = p;
        super.set(mCFSParams);
        mCFSParams2.progressShow = mCFSParams.progressShow;
        mCFSParams2.progressInterval = mCFSParams.progressInterval;
        mCFSParams2.threadsNumber = mCFSParams.threadsNumber;
        mCFSParams2.classifier = mCFSParams.classifier;
        mCFSParams2.projections = mCFSParams.projections;
        mCFSParams2.projectionSize = mCFSParams.projectionSize;
        mCFSParams2.projectionSizeAttr = mCFSParams.projectionSizeAttr;
        mCFSParams2.splits = mCFSParams.splits;
        mCFSParams2.splitRatio = mCFSParams.splitRatio;
        mCFSParams2.balanceRatio = mCFSParams.balanceRatio;
        mCFSParams2.splitSetSize = mCFSParams.splitSetSize;
        mCFSParams2.cutoffMethod = mCFSParams.cutoffMethod;
        mCFSParams2.buildID = mCFSParams.buildID;
        mCFSParams2.finalRuleset = mCFSParams.finalRuleset;
        mCFSParams2.finalCV = mCFSParams.finalCV;
        mCFSParams2.finalCVSetSize = mCFSParams.finalCVSetSize;
        mCFSParams2.finalCVRepetitions = mCFSParams.finalCVRepetitions;
        mCFSParams2.u = mCFSParams.u;
        mCFSParams2.v = mCFSParams.v;
        mCFSParams2.cutoffPermutations = mCFSParams.cutoffPermutations;
        mCFSParams2.cutoffAlpha = mCFSParams.cutoffAlpha;
        mCFSParams2.contrastAttr = mCFSParams.contrastAttr;
        mCFSParams2.contrastAttrThreshold = mCFSParams.contrastAttrThreshold;
        mCFSParams2.cutoffAngle = mCFSParams.cutoffAngle;
        mCFSParams2.wekaClassifierMode = mCFSParams.wekaClassifierMode;
        mCFSParams2.useGainRatio = mCFSParams.useGainRatio;
        mCFSParams2.maxConnectionDepth = mCFSParams.maxConnectionDepth;
        mCFSParams2.qMethod = mCFSParams.qMethod;
        mCFSParams2.useComplexQuality = mCFSParams.useComplexQuality;
        mCFSParams2.useDiversityMeasure = mCFSParams.useDiversityMeasure;
        return var1_1;
    }

    public final String getExperimentName() {
        return this.inputFileName.substring(0, this.inputFileName.lastIndexOf(46));
    }

    /*
     * WARNING - void declaration
     */
    public static String getExperimentName(String fileName) {
        void var2_2;
        int experimentPrefixIndex = fileName.lastIndexOf("__");
        if (experimentPrefixIndex == -1) {
            experimentPrefixIndex = fileName.lastIndexOf("_");
        }
        String experimentPrefix = "";
        if (experimentPrefixIndex != -1) {
            void var1_1;
            String string;
            experimentPrefix = string.substring(0, (int)(var1_1 + true));
        }
        return var2_2;
    }
}

