% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makefile.R
\name{makefile}
\alias{makefile}
\title{Generate Makefile from given list of rules (\code{job}).}
\usage{
makefile(
  job = list(),
  fileName = NULL,
  makeScript = "Makefile.R",
  vars = NULL,
  all = TRUE,
  tasks = TRUE,
  clean = TRUE,
  makefile = TRUE,
  depends = NULL
)
}
\arguments{
\item{job}{A list of rules (i.e. of instances of the S3 class \code{rmake.rule} - see \code{\link[=rule]{rule()}})}

\item{fileName}{A file to write to. If \code{NULL}, the result is returned as a character vector instead of
writing to a file.}

\item{makeScript}{A name of the file that calls this function (in order to generate
the \code{makefile} rule)}

\item{vars}{A named character vector of shell variables that will be declared in the resulting Makefile
(additionally to \verb{[defaultVars]})}

\item{all}{\code{TRUE} if the \code{all} rule should be automatically created and added: created \code{all} rule
has dependencies to all the other rules, which causes that everything is built if \verb{make all} is executed
in shell's command line.}

\item{tasks}{\code{TRUE} if "task" rules should be automatically created and added -- see \code{\link[=rule]{rule()}} for
more details.}

\item{clean}{\code{TRUE} if the \code{clean} rule should be automatically created and added}

\item{makefile}{\code{TRUE} if the \code{Makefile} rule should be automatically created and added: this rule
causes that any change in the R script - that generates the \code{Makefile} (i.e. that calls \code{\link[=makefile]{makefile()}}) -
issues the re-generation of the Makefile in the beginning of any build.}

\item{depends}{a character vector of file names that the makefile generating script depends on}
}
\value{
If \code{fileName} is \code{NULL}, the function returns a character vector with the contents of the
Makefile. Instead, the content is written to the given \code{fileName}.
}
\description{
In the (GNU) \code{make} jargon, \emph{rule} is a sequence of commands to build a result. In this package, rule
should be understood similarly: It is a command or a sequence of command that optionally produces some
files and depends on some other files (such as data files, scripts) or other rules. Moreover, a rule
contain a command for cleanup, i.e. for removal of generated files.
}
\details{
The \code{\link[=makefile]{makefile()}} function takes a list of rules (see \code{\link[=rule]{rule()}}) and generates a \code{Makefile} from them.
Additionally, \code{all} and \code{clean} rules are optionally generated too, which can be executed from shell
by issuing \verb{make all} or \verb{make clean} command, respectively, in order to build everything or erase all
generated files.

If there is a need to group some rules into a group, it can be done either via dependencies or by using
the \code{task} mechanism. Each rule may get assigned one or more tasks (see \code{task} in \code{\link[=rule]{rule()}}). Each
task is then created as a standalone rule depending on assigned rules. That way, executing \verb{make task_name}
will build all rules with assigned task \code{task_name}. By default, all rules are assigned to task \code{all},
which allows \verb{make all} to build everything.
}
\examples{
# create some jobs
job <- list(
    rRule('dataset.rds', 'preprocess.R', 'dataset.csv'),
    markdownRule('report.pdf', 'report.Rmd', 'dataset.rds'),
    markdownRule('details.pdf', 'details.Rmd', 'dataset.rds'))

# generate Makefile (output as a character vector)
makefile(job)

# generate to file
tmp <- tempdir()
makefile(job, file.path(tmp, "Makefile"))
}
\seealso{
\code{\link[=rule]{rule()}}, \code{\link[=rmakeSkeleton]{rmakeSkeleton()}}
}
\author{
Michal Burda
}
