% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_lithology_att.R
\name{def_lithology_att}
\alias{def_lithology_att}
\title{Define lithology attributes}
\usage{
def_lithology_att(
  lithology_att = NULL,
  att_type = NULL,
  lithology_att_id = NULL
)
}
\arguments{
\item{lithology_att}{\code{character}. The name of the lithology attribute
(e.g., "cross-bedded") to return a definition for.}

\item{att_type}{\code{character}. The type of lithology attribute (e.g., "sed
structure") to return a definition for.}

\item{lithology_att_id}{\code{integer}. The unique identification number(s)
of lithology attribute(s) to return a definition for.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{lith_att_id}: The unique identifier of the lithology attribute.
\item \code{name}: The name of the lithology attribute.
\item \code{type}: The lithology attribute type.
\item \code{t_units}: The total number of Macrostrat units to which the
lithology attribute is attached.
}
}
\description{
A function to retrieve the definitions for one or more
lithology attributes in the Macrostrat database. By default, all lithology
attribute definitions are returned.
}
\section{Developer(s)}{

Bethany Allen
}

\section{Reviewer(s)}{

Christopher D. Dean
}

\examples{
\donttest{
# Return all lithology attribute definitions
ex1 <- def_lithology_att()
# Return subsets of lithology attribute definitions
ex2 <- def_lithology_att(att_type = "sed structure")
}
}
\seealso{
Geologic features and attributes:
\code{\link{def_econs}()},
\code{\link{def_environments}()},
\code{\link{def_grain_sizes}()},
\code{\link{def_lithologies}()},
\code{\link{def_measurements}()},
\code{\link{def_minerals}()},
\code{\link{def_structures}()}
}
\concept{defs_feat}
