% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_path_generator.r
\name{path}
\alias{path}
\title{Generator of linear fractional stable motion}
\usage{
path(
  N = NULL,
  m,
  M,
  alpha,
  H,
  sigma,
  freq,
  disable_X = FALSE,
  levy_increments = NULL,
  seed = NULL
)
}
\arguments{
\item{N}{a number of points of the lfsm.}

\item{m}{discretization. A number of points between two nearby motion points}

\item{M}{truncation parameter. A number of points at which the integral representing the definition of lfsm is calculated. So, after M points back we consider the rest of the integral to be 0.}

\item{alpha}{self-similarity parameter of alpha stable random motion.}

\item{H}{Hurst parameter}

\item{sigma}{Scale parameter of lfsm}

\item{freq}{Frequency of the motion. It can take two values: "H" for high frequency and "L" for the low frequency setting.}

\item{disable_X}{is needed to disable computation of X. The default value is FALSE. When it is TRUE, only a levy motion is returned, which in turn reduces the computation time. The feature is particularly useful for reproducibility when combined with seeding.}

\item{levy_increments}{increments of Levy motion underlying the lfsm.}

\item{seed}{this parameter performs seeding of path generator}
}
\value{
It returns a list containing the motion, the underlying Levy motion, the point number of the motions from 0 to N and the corresponding coordinate (which depends on the frequency), the parameters that were used to generate the lfsm, and the predefined frequency.
}
\description{
The function creates a 1-dimensional lfsm sample path using the numerical algorithm from the paper by Stoev and Taqqu. Linear fractional stable motion is defined as
\deqn{X_t = \int_{\R} \left\{(t-s)_+^{H-1/\alpha} - (-s)_+^{H-1/\alpha} \right\} dL_s}
}
\examples{
# Path generation

m<-256; M<-600; N<-2^10-M
alpha<-1.8; H<-0.8; sigma<-0.3
seed=2

List<-path(N=N,m=m,M=M,alpha=alpha,H=H,
           sigma=sigma,freq='L',disable_X=FALSE,seed=3)

# Normalized paths
Norm_lfsm<-List[['lfsm']]/max(abs(List[['lfsm']]))
Norm_oLm<-List[['levy_motion']]/max(abs(List[['levy_motion']]))

# Visualization of the paths
plot(Norm_lfsm, col=2, type="l", ylab="coordinate")
lines(Norm_oLm, col=3)
leg.txt <- c("lfsm", "oLm")
legend("topright",legend = leg.txt, col =c(2,3), pch=1)


# Creating Levy motion
levyIncrems<-path(N=N, m=m, M=M, alpha, H, sigma, freq='L',
                  disable_X=TRUE, levy_increments=NULL, seed=seed)

# Creating lfsm based on the levy motion
  lfsm_full<-path(m=m, M=M, alpha=alpha,
                  H=H, sigma=sigma, freq='L',
                  disable_X=FALSE,
                  levy_increments=levyIncrems$levy_increments,
                  seed=seed)

sum(levyIncrems$levy_increments==
    lfsm_full$levy_increments)==length(lfsm_full$levy_increments)




}
\references{
\insertRef{StoevTaqqu04}{rlfsm}
}
\seealso{
\code{\link{paths}} simulates a number of lfsm sample paths.
}
