% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limit_theorems.R
\name{ContinEstim}
\alias{ContinEstim}
\title{Parameter estimation procedure in continuous case.}
\usage{
ContinEstim(t1, t2, p, k, path, freq)
}
\arguments{
\item{t1, t2}{real number such that  t2 > t1 > 0}

\item{p}{power}

\item{k}{increment order}

\item{path}{sample path of lfsm on which the inference is to be performed}

\item{freq}{Frequency of the motion. It can take two values: "H" for high frequency and "L" for the low frequency setting.}
}
\description{
'Unnecessary' parameter freq is preserved to allow for investigation of the inference procedure in high frequency case
}
\examples{
m<-45; M<-60; N<-2^10-M
alpha<-0.8; H<-0.8; sigma<-0.3
p<-0.3; k=3; t1=1; t2=2

lfsm<-path(N=N,m=m,M=M,alpha=alpha,H=H,
           sigma=sigma,freq='L',disable_X=FALSE,seed=3)$lfsm
ContinEstim(t1,t2,p,k,path=lfsm,freq='L')
}
\references{
\insertRef{MOP18}{rlfsm}
}
