% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_sa_item.R
\name{set_name}
\alias{set_name}
\title{Set the name of a SaItem}
\usage{
set_name(sa_item, name)
}
\arguments{
\item{sa_item}{a \code{"sa_item"} object.}

\item{name}{the new name.}
}
\value{
a new \code{"sa_item"} with the new name.
}
\description{
Function to set the name of a \code{"sa_item"}.
}
\examples{

library("RJDemetra")

sa_x13 <- jx13(series = ipi_c_eu[, "FR"])

wk <- new_workspace()
sap1 <- new_multiprocessing(workspace = wk, name = "sap-1")

add_sa_item(workspace = wk, multiprocessing = "sap-1",
            sa_obj = sa_x13, name = "Wrong name")

sa_item1 <- get_object(x = sap1, pos = 1L)

new_sa_item <- set_name(sa_item = sa_item1, name = "Good name")
replace_sa_item(sap = sap1, pos = 1L, sa_item = new_sa_item)

# The first sa_item of sap1 is now "Good name"
get_name(x = get_object(x = sap1, pos = 1L))

}
