% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverplot.R
\name{plot.riverplot}
\alias{plot.riverplot}
\alias{riverplot}
\title{Create a Sankey plot}
\usage{
\method{plot}{riverplot}(x, ...)

riverplot(
  x,
  direction = "lr",
  lty = 0,
  default_style = NULL,
  gravity = "top",
  node_margin = 0.1,
  nodewidth = 1.5,
  plot_area = c(1, 0.5),
  nsteps = 50,
  disentangle = TRUE,
  add_mid_points = TRUE,
  yscale = "auto",
  add = FALSE,
  usr = NULL,
  adjust.usr = FALSE,
  rescale = TRUE,
  fix.pdf = FALSE,
  bty = "n",
  ...
)
}
\arguments{
\item{x}{An object of class riverplot}

\item{...}{any further parameters passed to riverplot() are appended to the default style}

\item{direction}{"lr" (left to right) or "rl" (right to left)}

\item{lty}{Line style to use}

\item{default_style}{default graphical style}

\item{gravity}{how the nodes are placed vertically. No effect if node
vertical positions are specified via \var{node_ypos} member}

\item{node_margin}{how much vertical space should be kept between the
nodes}

\item{nodewidth}{width of the node (relative to font size)}

\item{plot_area}{fraction of vertical and horizontal space to be used as main plot area
If it is a numeric vector of two numbers, the first one is
horizontal space, the second vertical.}

\item{nsteps}{number of interpolating steps in drawing the segments}

\item{disentangle}{try to disentangle connections between the nodes. If
FALSE, the vertical ordering of the connections is the same as in the
x$edges data frame.}

\item{add_mid_points}{attempt to get a smoother plot by adding additional
nodes. Set this parameter to \code{FALSE} if you are setting node
vertical position manually. If add_mid_points is equal to TRUE (the
default), then the
mid points are added only if \var{node_ypos} is empty.}

\item{yscale}{scale the edge width values by multiplying with this
factor. If \var{yscale} is equal to "auto", scaling is done
automatically such that the vertical size of the largest node is
approximately 15% of the range of ypos (if present). 
If no \var{node_ypos} is specified in the riverplot object, no scaling is
done. If \var{yscale} is equal to 1, no scaling is done.
This parameter only influences the plot if the y positions of the
nodes are provided in \code{x$nodes}.}

\item{add}{If TRUE, do not call plot.new(), but add to the existing plot.}

\item{usr}{coordinates at which to draw the plot in form (x0, x1, y0, y1). 
If NULL, par("usr") will be used instead.}

\item{adjust.usr}{If TRUE, the par("usr")
will be modified to suit the x and y coordinates of the riverplot
nodes (whether the coordinates were given in the nodes, or
calculated by the function). In combination with providing x and y
coordinates, this allows a true representation of a riverplot object.
Necessary if you plan to plot additional, external data. If TRUE,
then \code{rescale} is set to FALSE.
See \code{\link{minard}} data set and example for details.}

\item{rescale}{if TRUE, then the plot will be fit into the given
user coordinates range (set by the usr parameter, for example, or the whole plot
region). If FALSE, the x and y positions of the nodes will be
treated as user coordinates and used to directly plot on the device.}

\item{fix.pdf}{Try to fix PDF output if it looks broken (with thin white lines). Don't use this option if you are using transparent colors.}

\item{bty}{box type to draw around the plot; see \code{bty} in documentation for \code{\link{par}} for details.}
}
\value{
\code{riverplot} returns a riverplot object, a graph which you
can plot again with riverplot(), but which additionally contains
information on node position and size in the \code{$nodes} member.
}
\description{
Create a Sankey plot
}
\details{
This functions create a Sankey plot given a riverplot object
(\code{plot} is just a wrapper for the \code{riverplot} function.
The object to be drawn is a list specifying the plot; see
the \code{\link{makeRiver}} function for exact specifications and
the \code{\link{riverplot.example}} to see how it can be created.
Whether or not the list used to plot is exactly of class
\code{riverplot-class} does not matter as long as it has the correct
contents. 

Style information which is missing from the riverplot object \code{x} (for example, if the
node style is not specified for each node in the object) is taken from the \code{default.style} parameter.
See functions \code{\link{default.style}()} and
\code{\link{updateRiverplotStyle}()} to learn how to create and
modify the styles.

Whether or not the list used to plot is exactly of class
\code{riverplot-class} does not matter as long as it has the correct
contents. These functions here are for the convenience of checking that

The nodes are drawn from bottom to top in the order they are found in
the riverplot object. There is no clever algorithm for placing the nodes
minimizing the number of crossing edges yet; you need to manipulate the
object directly to achieve the desired effect.
}
\section{Known problems}{

There is a problem with transparency and PDFs.
In short, if you try to save your riverplot graphics as PDF, you will
observe thin, white vertical lines everywhere on the curves. The reasons
for that are unclear, but have something to do with PDF rendering (if you
generate EPS, the output looks good).

There is a kind of fix to that: use the fix.pdf=TRUE option. Unfortunately,
this solution does not work if you use transparent colors (you will have a
different kind of vertical lines). Unfortunately, I don't have a solution
for that problem yet.
}

\examples{
x <- riverplot.example()
plot(x)
plot(x, srt=90, lty=1)

# add graphics at nodes
foo <- plot(x, srt=90, lty=1)
points(foo$nodes$x, foo$nodes$y, pch=19, cex=2)

# redraw the same graph using positions from foo object
plot(foo, yscale=1)
}
\seealso{
default.style updateRiverplotStyle minard
}
