% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_d_index_calculation.R
\name{inner_d_index_calculation}
\alias{inner_d_index_calculation}
\title{Calculate index improvement for scenarios of barriers removal - function not for export}
\usage{
inner_d_index_calculation(
  graph,
  barriers_metadata,
  id_barrier,
  pass_u_updated,
  pass_d_updated,
  mode = "leave_one_out",
  parallel,
  ncores,
  weight,
  nodes_id,
  index_type,
  index_mode,
  c_ij_flag,
  B_ij_flag,
  dir_fragmentation_type,
  pass_confluence,
  pass_u,
  pass_d,
  field_B,
  dir_distance_type,
  disp_type,
  param_u,
  param_d,
  param,
  param_l
)
}
\arguments{
\item{graph}{an object of class igraph. Can be both directed or undirected.}

\item{barriers_metadata}{data.frame that must contain a column having the same name as the 'id_barrier' attribute of the graph,
and two columns with the corresponding upstream and downstream improved passabilities (see pass_u_updated and pass_d_updated).}

\item{id_barrier}{graph edges attribute used to label barriers. Default is \code{"id_barrier"}.}

\item{pass_u_updated}{field in barrier_metadata where updated value for upstream passability is stored
(recommended values higher than the original passability).}

\item{pass_d_updated}{field in barrier_metadata where updated value for downstream passability is stored
(recommended values higher than the original passability).}

\item{mode}{currentlym only \code{"leave_one_out"} is implemented.}

\item{parallel}{logical value to flag if parallel option is to be used.}

\item{ncores}{define how many cores are used in parallel processing. Active only when \code{parallel = TRUE}}

\item{weight}{check index_calculation function.}

\item{nodes_id}{check index_calculation function.}

\item{index_type}{check index_calculation function.}

\item{index_mode}{check index_calculation function.}

\item{c_ij_flag}{check index_calculation function.}

\item{B_ij_flag}{check index_calculation function.}

\item{dir_fragmentation_type}{check index_calculation function.}

\item{pass_confluence}{check index_calculation function.}

\item{pass_u}{check index_calculation function.}

\item{pass_d}{check index_calculation function.}

\item{field_B}{check index_calculation function.}

\item{dir_distance_type}{check index_calculation function.}

\item{disp_type}{check index_calculation function.}

\item{param_u}{check index_calculation function.}

\item{param_d}{check index_calculation function.}

\item{param}{check index_calculation function.}
}
\value{
returns a data.frame containing the percent improvement of the index for
each barrier present in the 'barriers_metadata' variable.
If \code{index_type = "full"}, the data.frame is organized by 'id_barrier'.
If \code{index_type = "reach"}, the data.frame is organized by 'id_barrier' and 'name'.
In both cases, both numerator and denominator used in the index calculations are reported in the columns 'num' and 'den'.
The column 'd_index' contains the relative index improvement when each barrier is removed.
}
\description{
Calculate index improvement for scenarios of barriers removal - function not for export
}
\details{
Setting \code{c_ij_flag = FALSE} removes from the calculations the effect of barriers, i.e. the c_{ij} contribution
is not used in the calculation of the index.
Setting \code{B_ij_flag = FALSE} removes from the calculations the effect of movement/dispersal,
i.e. the B_{ij} contribution is not used in the calculation of the index.
Note that it is not possible to set both \code{c_ij_flag = FALSE} and \code{B_ij_flag = FALSE}.

The setting \code{dir_distance_type = "symmetric"} is to be used when the directionality of the river network is not relevant.
The distance between reaches midpoints is calculated for each couple of reaches.
The setting \code{dir_distance_type = "asymmetric"} is to be used when the directionality is relevant.
The distance between reaches midpoints is calculated for each couple of reaches and splitted
between 'upstream travelled' distance and 'downstream travelled' distance

The 'param_u', 'param_d', and 'param' values are interpreted differently based on the formula used to relate distance and probability.
When \code{disp_type ="exponential"}, those values are used as the base of the exponential dispersal kernel: B_ij = param^{d_ij}.
When \code{disp_type ="threshold"}, those values are used to define the maximum dispersal length: B_ij = ifelse(d_ij < param, 1, 0).
}
\keyword{internal}
