% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup-attach.R
\name{setup_src_data}
\alias{setup_src_data}
\title{Data setup}
\usage{
setup_src_data(x, ...)
}
\arguments{
\item{x}{Object specifying the source configuration}

\item{...}{Forwarded to \code{\link[=load_src_cfg]{load_src_cfg()}} if \code{x} is a character vector}
}
\value{
Called for side effects and returns \code{NULL} invisibly.
}
\description{
Making a dataset available to \code{ricu} consists of 3 steps: downloading
(\code{\link[=download_src]{download_src()}}), importing (\code{\link[=import_src]{import_src()}}) and attaching
(\code{\link[=attach_src]{attach_src()}}). While downloading and importing are one-time procedures,
attaching of the dataset is repeated every time the package is loaded.
Briefly, downloading loads the raw dataset from the internet (most likely
in \code{.csv} format), importing consists of some preprocessing to make the
data available more efficiently and attaching sets up the data for use by
the package. The download and import steps can be combined using
\code{setup_src_data()}.
}
\details{
If \code{setup_src_data()} is called on data sources that have all data available
with \code{force = FALSE}, nothing happens apart of a message being displayed. If
only a subset of tables is missing, only these tables are downloaded
(whenever possible) and imported. Passing \code{force = TRUE} attempts to re-
download and import the entire data set. If the data source is available
as a data package (as is the case for the two demo datasets), data is not
downloaded and imported, but this package is installed.

In most scenarios, \code{setup_src_data()} does not need to be called by users,
as upon package loading, all configured data sources are set up in a way
that enables download of missing data upon first access (and barring user
consent). However, instead of accessing all data sources where data
missingness should be resolved one by one, \code{setup_src_data()} is exported
for convenience.
}
