% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-cli.R
\name{msg_progress}
\alias{msg_progress}
\alias{fmt_msg}
\title{Message signaling nested with progress reporting}
\usage{
msg_progress(..., envir = parent.frame())

fmt_msg(msg, envir = parent.frame(), indent = 0L, exdent = 0L)
}
\arguments{
\item{...}{Passed to \code{\link[base:message]{base::.makeMessage()}}}

\item{envir}{Environment in this objects from \code{msg} are evaluated}

\item{msg}{String valued message}

\item{indent, exdent}{Vector valued and mapped to \code{\link[fansi:strwrap_ctl]{fansi::strwrap2_ctl()}}}
}
\value{
Called for side effects and returns \code{NULL} invisibly.
}
\description{
In order to not interrupt progress reporting by a \link[progress:progress_bar]{progress::progress_bar},
messages are wrapped with class \code{msg_progress} which causes them to be
captured printed after progress bar completion. This function is intended to
be used when signaling messages in callback functions.
}
\examples{
msg_progress("Foo", "bar")

capt_fun <- function(x) {
  message("captured: ", conditionMessage(x))
}

tryCatch(msg_progress("Foo", "bar"), msg_progress = capt_fun)

}
