% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marine.R
\name{weighted_means}
\alias{weighted_means}
\title{Calculate the weighted mean of C14 ages}
\usage{
weighted_means(y, er, round = 1, talk = TRUE)
}
\arguments{
\item{y}{The C14 ages.}

\item{er}{The lab errors of the C14 ages.}

\item{round}{Rounding to be applied (defaults to 1 decimal).}

\item{talk}{Report details of the found values.}
}
\value{
The weighted mean and error (the latter is the maximum of the weighted error and the square root of the variance).
}
\description{
Calculating the weighted mean of multiple C14 ages, using their means and lab errors.
}
\examples{
  N_UK <- map.shells(53, -11, 60, 2, mapsize="small")
  weighted_means(N_UK$dR, N_UK$dSTD)
}
