% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{caldist}
\alias{caldist}
\title{Calculate calibrated distribution}
\usage{
caldist(
  y,
  er,
  cc = 1,
  postbomb = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  is.F = FALSE,
  is.pMC = FALSE,
  as.F = FALSE,
  thiscurve = NULL,
  yrsteps = FALSE,
  cc.resample = FALSE,
  dist.res = 200,
  cc0.res = 5000,
  threshold = 0.001,
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  normalise = TRUE,
  BCAD = FALSE,
  rule = 1,
  cc.dir = NULL,
  col.names = NULL
)
}
\arguments{
\item{y}{Uncalibrated radiocarbon age}

\item{er}{Lab error of the radiocarbon age}

\item{cc}{Calibration curve to use. Defaults to IntCal20 (\code{cc=1}).}

\item{postbomb}{Whether or not to use a postbomb curve. Required for negative radiocarbon ages.}

\item{deltaR}{Age offset (e.g. for marine samples).}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation).}

\item{is.F}{Set this to TRUE if the provided age and error are in the F14C realm.}

\item{is.pMC}{Set this to TRUE if the provided age and error are in the pMC realm.}

\item{as.F}{Whether or not to calculate ages in the F14C realm. Defaults to \code{as.F=FALSE}, which uses the C14 realm.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{yrsteps}{Steps to use for interpolation. Defaults to the cal BP steps in the calibration curve}

\item{cc.resample}{The IntCal20 curves have different densities (every year between 0 and 5 kcal BP, then every 5 yr up to 15 kcal BP, then every 10 yr up to 25 kcal BP, and then every 20 yr up to 55 kcal BP). If calibrated ages span these density ranges, their drawn heights can differ, as can their total areas (which should ideally all sum to the same size). To account for this, resample to a constant time-span, using, e.g., \code{cc.resample=5} for 5-yr timespans.}

\item{dist.res}{As an alternative to yrsteps, provide the amount of 'bins' in the distribution.}

\item{cc0.res}{Length of 'curve' when cc=0 (no calibration curve). Defaults to 5000, in order to provide enough points for detailed distributions.}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=1e-6}.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{normalise}{Sum the entire calibrated distribution to 1. Defaults to \code{normalise=TRUE}.}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{rule}{Which extrapolation rule to use. Defaults to \code{rule=1} which returns NAs.}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{col.names}{Names for the output columns. Defaults to calBP/BCAD and probs, respectively (depending on the value of BCAD).}
}
\value{
The probability distribution(s) as two columns: cal BP ages and their associated probabilities
}
\description{
Calculate the calibrated distribution of a radiocarbon date.
}
\examples{
calib <- caldist(130,10)
plot(calib, type="l")
postbomb <- caldist(-3030, 20, postbomb=1, BCAD=TRUE)
}
