% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_matrices.R
\name{adjacency_matrix}
\alias{adjacency_matrix}
\title{Find the Adjacency Matrix of a Hypergraph}
\usage{
adjacency_matrix(hype, normalise = TRUE, self_adj = TRUE)
}
\arguments{
\item{hype}{A hypergraph object}

\item{normalise}{Whether the matrix should be normalised to either 1 or 0}

\item{self_adj}{Whether self adjacency should be represented}
}
\value{
A matrix of adjacencies between vertices of a hypergraph.
}
\description{
An adjacency matrix is a square matrix with both rows and columns being
indexed by vertices. For each entry, the number is proportional to the
strength of the connection going from the vertex represented as the row and
the vertex represented by the column. For undirected hypergraphs, this matrix
is symmetric but this is usually not the case for directed.
}
\details{
Great care should be taken when using a hypergraph with mixed positive and
negative real coefficients as there is a chance no adjacency will be registered
for two adjacenct vertices. rhype does not check for these cases and they must
be checked for by the user.
}
\examples{
h1 <- example_hype()
adjacency_matrix(h1)

h2 <- example_hype(oriented = TRUE, directed = TRUE)
adjacency_matrix(h2)
}
