% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComByCoord.R
\name{ComByCoord}
\alias{ComByCoord}
\title{Get City by Coordinates}
\usage{
ComByCoord(lat, lon, postal = FALSE)
}
\arguments{
\item{lat}{a character string with latitude (WGS-84)}

\item{lon}{a character string with longitude (WGS-84)}

\item{postal}{wether or not to include postal codes. Default is FALSE.}
}
\value{
Returns a data.frame with name, INSEE code, postal code, INSEE department code, INSEE region code, population (approx), surface (in hectares), lat and long (WGS-84).
}
\description{
Get informations about a French city by its Coordinates (WGS-84). Please note that this package works only with French cities.
}
\details{
Takes the latitude and longitude of a city, returns a data.frame with the available values.
}
\note{
If you don't know the coordinates of the city you're looking for, you can find it by using the \code{\link{ComByName}} function.
}
\examples{
ComByCoord(lat = "48.11023", lon = "-1.678872") 
ComByCoord(lat = "48.74313", lon = "-3.460337", postal = TRUE)
}

