% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task.R
\name{gd_task_status}
\alias{gd_task_status}
\alias{gd_task_uri}
\title{Get Earth Engine Task Status}
\usage{
gd_task_status(x)

gd_task_uri(x, asset_only = TRUE)
}
\arguments{
\item{x}{An object of class \code{"ee.batch.Task"}}

\item{asset_only}{Default: \code{TRUE}. For export tasks with \code{type="asset"}, return only the asset ID, rather than whole URL. Other export task types return a full path to either Google Drive or Google Cloud location. When \code{FALSE} the path is a HTTPS link to an Earth Engine asset.}
}
\value{
\code{gd_task_status()}: returns the status from an \code{"ee.batch.Task"} object

\code{gd_task_uri()}: returns the destination URI(s) associated with a task.
}
\description{
\code{gd_task_status()} and \code{gd_task_uri()} are helper functions for working with tasks  scheduled with \code{gd_export()}
}
\examples{
\dontrun{
if (gd_is_initialized()) {
  r <- gd_bbox(
    xmin = -120.6032,
    xmax = -120.5377,
    ymin = 38.0807,
    ymax = 38.1043
  )
  
  i <- gd_image_from_id('CSP/ERGo/1_0/US/CHILI')
  ex <- gd_export(
    i,
    region = r,
    type = "asset",
    filename = "RGEEDIM_TEST",
    folder = "your-project-name",
    scale = 30
  )
  
  gd_task_status(ex)
  
  r <- gd_download(
    gd_task_uri(ex),
    filename = "image.tif",
    region = r,
    overwrite = TRUE
  )
  
  library(terra)
  plot(rast(r))
}
}
}
\seealso{
\code{\link[=gd_export]{gd_export()}} \code{\link[=gd_download]{gd_download()}}
}
