% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_install.R
\name{ee_install}
\alias{ee_install}
\title{Create an isolated Python virtual environment with all rgee dependencies.}
\usage{
ee_install(
  py_env = "rgee",
  earthengine_version = ee_version(),
  confirm = interactive()
)
}
\arguments{
\item{py_env}{Character. The name, or full path, of the Python environment
to be used by rgee.}

\item{earthengine_version}{Character. The Earth Engine Python API version
to install. By default \code{rgee::ee_version()}.}

\item{confirm}{Logical. Confirm before restarting R?.}
}
\value{
No return value, called for installing non-R dependencies.
}
\description{
Create an isolated Python virtual environment with all rgee dependencies.
\code{ee_install} realize the following six (6) tasks:
\itemize{
\item{1. }{If you do not count with a Python environment, it will display
an interactive menu to install \href{https://docs.conda.io/en/latest/miniconda.html}{Miniconda}
(a free minimal installer for conda).}
\item{2. }{Remove the previous Python environment defined in \code{py_env} if
it exist.}
\item{3. }{Create a new Python environment (See \code{py_env}).}
\item{4. }{ Set the environment variable EARTHENGINE_PYTHON. It is used to
define RETICULATE_PYTHON when the library is loaded. See this
\href{https://rstudio.github.io/reticulate/articles/versions.html}{article}
for further details.
}
\item{5. }{Install rgee Python dependencies. Using
\code{reticulate::py_install}.}
\item{6. }{Interactive menu to confirm if restart the R session to see
changes.}
}
}
\seealso{
Other ee_install functions: 
\code{\link{ee_install_set_pyenv}()},
\code{\link{ee_install_upgrade}()}
}
\concept{ee_install functions}
