% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_image.R
\name{ee_image_info}
\alias{ee_image_info}
\title{Approximate size of an EE Image object}
\usage{
ee_image_info(image, getsize = TRUE, compression_ratio = 20, quiet = FALSE)
}
\arguments{
\item{image}{Single-band EE Image object.}

\item{getsize}{Logical. If TRUE, the size of the object
will be estimated.}

\item{compression_ratio}{Numeric. Measurement of the relative reduction
in size of data representation produced by a data compression algorithm
(ignored if \code{getsize} is FALSE). By default is 20}

\item{quiet}{Logical. Suppress info message}
}
\value{
A list containing information about the number of rows (nrow),
number of columns (ncol), total number of pixels (total_pixel), and image
size (image_size).
}
\description{
Get the approximate number of rows, cols, and size of an single-band
Earth Engine Image.
}
\examples{
\dontrun{
library(rgee)
ee_Initialize()

# World SRTM
srtm <- ee$Image("CGIAR/SRTM90_V4")
ee_image_info(srtm)

# Landast8
l8 <- ee$Image("LANDSAT/LC08/C01/T1_SR/LC08_038029_20180810")$select("B4")
ee_image_info(l8)
}
}
