% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_get.R
\name{ee_get_date_img}
\alias{ee_get_date_img}
\title{Get the date of a EE Image}
\usage{
ee_get_date_img(x, time_end = FALSE)
}
\arguments{
\item{x}{ee$Image or ee$ImageCollection object}

\item{time_end}{Logical. If TRUE, the \code{system:time_end} property is
also returned. See details.}
}
\value{
An List object with the elements: id, time_start and time_end
(if the \code{time_end} argument is TRUE).
}
\description{
Get the date of a EE Image
}
\details{
\code{system:time_start} set the start period of data acquisition while
\code{system:time_end} does the same for the end period. See the
\href{https://developers.google.com/earth-engine/glossary/}{Earth Engine glossary}
for getting more information.
}
\examples{
\dontrun{
library(rgee)
ee_Initialize()

l8 <- ee$Image('LANDSAT/LC08/C01/T1_TOA/LC08_044034_20140318')
ee_get_date_img(l8)
srtm <- ee$Image('CGIAR/SRTM90_V4')
ee_get_date_img(srtm, time_end = TRUE)
}
}
\seealso{
Other date functions: 
\code{\link{ee_get_date_ic}()},
\code{\link{eedate_to_rdate}()},
\code{\link{rdate_to_eedate}()}
}
\concept{date functions}
