% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\name{get_param_dirs}
\alias{get_param_dirs}
\title{List the directories containing param files}
\usage{
get_param_dirs(param_files)
}
\arguments{
\item{param_files}{Character, path to a top-level
directory containing param files. \code{\link[=run_flfll]{run_flfll()}} and \code{\link[=run_facts]{run_facts()}}
return paths you can supply to \code{param_files} in \code{get_param_dirs()}.}
}
\value{
Character vector of FACTS simulation scenario directories.
}
\description{
Get the directory paths containing param files.
This helps us run FACTS simulation scenarios one at a time.
}
\details{
When you run \code{\link[=run_flfll]{run_flfll()}} or \code{\link[=run_facts]{run_facts()}}, \code{rfacts}
creates a directory. This directory has a bunch of
subdirectories, each corresponding to a single simulation scenario
(VSR profile x accrual profile x dropout profile, etc).
}
\examples{
# Can only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
facts_file <- get_facts_file_example("contin.facts")
param_files <- run_flfll(facts_file, verbose = FALSE)
scenarios <- get_param_dirs(param_files)
scenarios
scenario <- scenarios[1]
run_engine_contin(scenario, n_sims = 2, verbose = FALSE, version = "6.2.5")
read_patients(scenario)
}
}
\seealso{
\code{\link[=get_facts_scenarios]{get_facts_scenarios()}}, \code{\link[=run_facts]{run_facts()}}, \code{\link[=run_flfll]{run_flfll()}},
\code{\link[=run_engine]{run_engine()}}, \code{\link[=run_engine_contin]{run_engine_contin()}}
}
