% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_facts.R
\name{read_facts}
\alias{read_facts}
\title{Read parts of FACTS files.}
\usage{
read_facts(facts_file, fields)
}
\arguments{
\item{facts_file}{Character of length 1, path to FACTS XML file to read.}

\item{fields}{Data frame defining the kind of XML data to be read.
It must have one row per field definition and the following columns:
\enumerate{
\item \code{field}: custom name of the field.
\item \code{type}: value of the "type" attribute of the \verb{<parameterSets>} tag.
\item \code{set}: value of the "name" attribute of the \verb{<parameterSet>} tag.
\item \code{property}: value of the "name" attribute of the \verb{<property>} tag.
}}
}
\value{
A one-row \code{tibble} with the requested fields from the FACTS file.
}
\description{
Read specific fields of a FACTS file.
}
\details{
A FACTS file has a special kind of XML format.
Most of the content sits in an overarching \verb{<facts>} tag,
then a \verb{<parameterSets>} tag, then a
\verb{<parameterSet>} tag, then a \verb{<property>} tag.
For example, here is the part of a FACTS file that controls
the weeks between interims.\if{html}{\out{<div class="xml">}}\preformatted{<facts>
  <parameterSets type="NucleusParameterSet">
    <parameterSet name="nucleus">
      <property name="update_freq_save">4</property>
}\if{html}{\out{</div>}}

To use the \code{read_facts()} function, you must first identify
the parts of the FACTS file you want to read using the \code{fields} argument.
To read the above part of the XML, you would first define the
\code{update_freq_save} field.\if{html}{\out{<div class="r">}}\preformatted{fields <- tibble::tibble(
  field = "my_interval",
  type = "NucleusParameterSet",
  set = "nucleus",
  property = "update_freq_save"
)
}\if{html}{\out{</div>}}

and then call \code{read_facts(input = "your_file.facts", fields = fields)}.
}
\examples{
facts_file <- get_facts_file_example("contin.facts")
fields <- data.frame(
  field = c("my_subjects", "my_vsr"),
  type = c("NucleusParameterSet", "EfficacyParameterSet"),
  set = c("nucleus", "resp2"),
  property = c("max_subjects", "true_endpoint_response")
)
read_facts(facts_file = facts_file, fields = fields)
}
