% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eutil.R, R/elink.R, R/esearch.R
\docType{methods}
\name{uid}
\alias{uid}
\alias{uid,elink-method}
\alias{uid,entrez_linkset-method}
\alias{uid,entrez_uid-method}
\alias{uid,esearch-method}
\title{uid}
\usage{
uid(x, ...)

\S4method{uid}{entrez_linkset}(x, ...)

\S4method{uid}{elink}(x, ...)

\S4method{uid}{entrez_uid}(x, ...)

\S4method{uid}{esearch}(x, ...)
}
\arguments{
\item{x}{An \code{\linkS4class{eutil}} object.}

\item{...}{Further arguments passed on to methods.}
}
\value{
A character vector.
}
\description{
Retrieve the list of UIDs returned by a call to ESearch or ELink.
}
\section{Methods (by class)}{
\itemize{
\item \code{entrez_linkset}: Retrieve the list of UIDs from an \code{entrez_linkset} object.

\item \code{elink}: Retrieve the list of UIDs from an \code{elink} object.

\item \code{entrez_uid}: Retrieve the list of UIDs from an \code{entrez_uid} object.

\item \code{esearch}: Retrieve the list of UIDs from an \code{esearch} object.
}}
\examples{
\dontrun{
e <- esearch("Mus musculus", "taxonomy")
uid(e)
}
}
\seealso{
\code{\link{esearch}}, \code{\link{elink}}.
}

