% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eutil.R
\docType{class}
\name{eutil-class}
\alias{ecitmatch-class}
\alias{efetch-class}
\alias{egquery-class}
\alias{einfo-class}
\alias{elink-class}
\alias{epost-class}
\alias{esearch-class}
\alias{espell-class}
\alias{esummary-class}
\alias{eutil}
\alias{eutil-class}
\title{Class \code{"eutil"}: Reference classes that hold the response from EUtils
requests.}
\description{
The reference classes \code{\linkS4class{eutil}}, \code{\linkS4class{einfo}},
\code{\linkS4class{esearch}}, \code{\linkS4class{esummary}},
\code{\linkS4class{efetch}}, \code{\linkS4class{elink}}, \code{\linkS4class{epost}},
\code{\linkS4class{egquery}}, \code{\linkS4class{espell}}, and
\code{\linkS4class{ecitmatch}} implement the request generator for interaction
with the NCBI services.
They should not be used direcly, but initialized through the respective
constructor functions \code{\link{einfo}}, \code{\link{esearch}},
\code{\link{esummary}}, \code{\link{efetch}}, \code{\link{elink}},
\code{\link{epost}}, \code{\link{egquery}}, \code{\link{espell}}, and
\code{\link{ecitmatch}}.
}
\section{Fields}{

\describe{
\item{\code{params}}{A named \code{list} of query parameters.}

\item{\code{errors}}{A \code{\linkS4class{eutil_error}} object.}

\item{\code{content}}{Result of an Entrez request stored as a character vector.}
}}
\section{Methods}{

\describe{
\item{\code{get_content(as = "text", ...)}}{Return the results of an Entrez query as text, xml, json, a textConnection,
or parsed to a list or data.frame; should not be used directly, use
\code{\link{content}} instead.}

\item{\code{get_error()}}{Return \code{\linkS4class{eutil_error}}s; should not be used directly,
use \code{\link{getError}} instead.}

\item{\code{get_url()}}{Return the URL used for an Entrez query; should not be used directly,
use \code{\link{getUrl}} instead.}

\item{\code{perform_query(method = "GET", ...)}}{Perform an Entrez query using either http GET or POST requests;
should not be used directly.}

\item{\code{xmlAttr(xpath, name, as = "character", default = NA_character_)}}{Extract the value of XML attributes given a valid XPath expression
and an attribute name}

\item{\code{xmlName(xpath, as = "character", default = NA_character_)}}{Extract the tag names of XML nodes given a valid XPath expression.}

\item{\code{xmlSet(xpath, ...)}}{Extract a set of XML nodes given a valid XPath expression.}

\item{\code{xmlValue(xpath, as = "character", default = NA_character_)}}{Extract the text value of XML leaf nodes given a valid XPath expression.}
}}
\section{Extends}{
 All reference classes extend and inherit methods from
    \code{"\linkS4class{envRefClass}"}. Furthermore, \code{"einfo"},
    \code{"esearch"}, \code{"esummary"}, \code{"efetch"}, \code{"elink"},
    \code{"epost"}, \code{"egquery"}, \code{"espell"}, and \code{"ecitmatch"}
    all extend the \code{"eutil"} class.
}
\examples{
showClass("eutil")
}
\seealso{
\code{\linkS4class{eutil}}, \code{\link{einfo}},
\code{\link{esearch}}, \code{\link{esummary}}, \code{\link{efetch}},
\code{\link{elink}}, \code{\link{epost}}, \code{\link{egquery}},
\code{\link{espell}}, and \code{\link{ecitmatch}}.
}
\keyword{classes}
\keyword{internal}

