% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RetinalReconstructedOutline.R
\name{RetinalReconstructedOutline}
\alias{RetinalReconstructedOutline}
\title{A version of \link{ReconstructedOutline} that is specific to
retinal datasets}
\description{
A RetinalReconstructedOutline overrides methods of
  \link{ReconstructedOutline} so that they return data point and
  landmark coordinates that have been transformed according to the
  values of \code{DVflip} and \code{side}. When reconstructing, it
  also computes the \dQuote{Optic disc displacement}, i.e. the
  number of degrees subtended between the optic disc and the pole.
}
\author{
David Sterratt
}
\section{Super classes}{
\code{\link[retistruct:OutlineCommon]{retistruct::OutlineCommon}} -> \code{\link[retistruct:ReconstructedOutline]{retistruct::ReconstructedOutline}} -> \code{RetinalReconstructedOutline}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{EOD}}{Optic disc displacement in degrees}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-getIms}{\code{RetinalReconstructedOutline$getIms()}}
\item \href{#method-getTearCoords}{\code{RetinalReconstructedOutline$getTearCoords()}}
\item \href{#method-reconstruct}{\code{RetinalReconstructedOutline$reconstruct()}}
\item \href{#method-getFeatureSet}{\code{RetinalReconstructedOutline$getFeatureSet()}}
\item \href{#method-clone}{\code{RetinalReconstructedOutline$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="clearFeatureSets">}\href{../../retistruct/html/OutlineCommon.html#method-clearFeatureSets}{\code{retistruct::OutlineCommon$clearFeatureSets()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSets">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSets}{\code{retistruct::OutlineCommon$getFeatureSets()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSetTypes">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSetTypes}{\code{retistruct::OutlineCommon$getFeatureSetTypes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getIDs">}\href{../../retistruct/html/OutlineCommon.html#method-getIDs}{\code{retistruct::OutlineCommon$getIDs()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="getPoints">}\href{../../retistruct/html/ReconstructedOutline.html#method-getPoints}{\code{retistruct::ReconstructedOutline$getPoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="getStrains">}\href{../../retistruct/html/ReconstructedOutline.html#method-getStrains}{\code{retistruct::ReconstructedOutline$getStrains()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="loadOutline">}\href{../../retistruct/html/ReconstructedOutline.html#method-loadOutline}{\code{retistruct::ReconstructedOutline$loadOutline()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="mapFlatToSpherical">}\href{../../retistruct/html/ReconstructedOutline.html#method-mapFlatToSpherical}{\code{retistruct::ReconstructedOutline$mapFlatToSpherical()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="mergePointsEdges">}\href{../../retistruct/html/ReconstructedOutline.html#method-mergePointsEdges}{\code{retistruct::ReconstructedOutline$mergePointsEdges()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="optimiseMapping">}\href{../../retistruct/html/ReconstructedOutline.html#method-optimiseMapping}{\code{retistruct::ReconstructedOutline$optimiseMapping()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="optimiseMappingCart">}\href{../../retistruct/html/ReconstructedOutline.html#method-optimiseMappingCart}{\code{retistruct::ReconstructedOutline$optimiseMappingCart()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="projectToSphere">}\href{../../retistruct/html/ReconstructedOutline.html#method-projectToSphere}{\code{retistruct::ReconstructedOutline$projectToSphere()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="reconstructFeatureSets">}\href{../../retistruct/html/ReconstructedOutline.html#method-reconstructFeatureSets}{\code{retistruct::ReconstructedOutline$reconstructFeatureSets()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="ReconstructedOutline" data-id="transformImage">}\href{../../retistruct/html/ReconstructedOutline.html#method-transformImage}{\code{retistruct::ReconstructedOutline$transformImage()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getIms"></a>}}
\subsection{Method \code{getIms()}}{
Get coordinates of corners of pixels of image in spherical
  coordinates, transformed according to the value of \code{DVflip}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$getIms()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Coordinates of corners of pixels in spherical coordinates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTearCoords"></a>}}
\subsection{Method \code{getTearCoords()}}{
Get location of tear coordinates in spherical coordinates,
  transformed according to the value of \code{DVflip}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$getTearCoords()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Location of tear coordinates in spherical coordinates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reconstruct"></a>}}
\subsection{Method \code{reconstruct()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$reconstruct(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters to \code{\link{ReconstructedOutline}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFeatureSet"></a>}}
\subsection{Method \code{getFeatureSet()}}{
Get \link{ReconstructedFeatureSet}, transformed
  according to the value of \code{DVflip}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$getFeatureSet(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Base type of \link{FeatureSet} as string.
E.g. \code{PointSet} returns a \link{ReconstructedPointSet}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetinalReconstructedOutline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
