% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_jobs.R
\name{gen_list_jobs}
\alias{gen_list_jobs}
\title{gen_list_jobs}
\usage{
gen_list_jobs(
  database = c("genesis", "regio"),
  sortcriterion = c("type", "time", "status", "code"),
  flat = FALSE,
  ...
)
}
\arguments{
\item{database}{Character string. Indicator if 'genesis' or 'regionalstatistik.de' database is called. Default option is 'genesis'.}

\item{sortcriterion}{Character string. Indicator if the output should be sorted by 'type','time','status' or 'code'. This is a parameter of the API call itself. The default is 'type'.}

\item{flat}{Boolean. Should the function return a list with jobs and metadata ('FALSE') or just a flat data.frame ('TRUE')? Defaults to FALSE.}

\item{...}{Additional parameters for the API call. These parameters are only affecting the call itself, no further processing. For more details see \code{vignette("additional_parameter")}.}
}
\value{
A list or data.frame (see parameter 'flat') of all current jobs of the user.
}
\description{
Function to list all current jobs connected to the given user in the GENESIS or regionalstatistik.de database. Important note: For this function it is also possible to use \code{searchcriterion} parameter and \code{selection} parameter, making it possible to filter the job list based on 'type','time','status' or 'code'. For more details see \code{vignette("additional_parameter")}.
}
\examples{
\dontrun{
gen_list_jobs("regio", flat = TRUE)
}

}
