% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SshResourceResolver.R
\docType{class}
\name{SshResourceResolver}
\alias{SshResourceResolver}
\title{SSH Resource resolver}
\format{A R6 object of class SshResourceResolver}
\description{
SSH Resource resolver

SSH Resource resolver
}
\details{
The resource is a computation unit, accessible through SSH, i.e. which URL scheme is "ssh".
}
\section{Super class}{
\code{\link[resourcer:ResourceResolver]{resourcer::ResourceResolver}} -> \code{SshResourceResolver}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-isFor}{\code{SshResourceResolver$isFor()}}
\item \href{#method-newClient}{\code{SshResourceResolver$newClient()}}
\item \href{#method-clone}{\code{SshResourceResolver$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="ResourceResolver" data-id="initialize">}\href{../../resourcer/html/ResourceResolver.html#method-initialize}{\code{resourcer::ResourceResolver$initialize()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isFor"></a>}}
\subsection{Method \code{isFor()}}{
Check that the provided resource is a computation resource accessible by ssh commands. The resource URL scheme is expected to be "ssh".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SshResourceResolver$isFor(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-newClient"></a>}}
\subsection{Method \code{newClient()}}{
Create a SshResourceClient instance from the provided resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SshResourceResolver$newClient(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A SshResourceClient object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SshResourceResolver$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
