% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactness.R
\name{comp_ch}
\alias{comp_ch}
\title{Calculate Convex Hull Compactness}
\usage{
comp_ch(plans, shp, epsg = 3857, ncores = 1)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame with an \code{sf} geometry column.}

\item{epsg}{Numeric EPSG code to use to project the shapefile, if needed. Default is 3857.}

\item{ncores}{Integer number of cores to use. Default is 1.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Calculate Convex Hull Compactness
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
comp_ch(plans = nh$r_2020, shp = nh)

# Or many plans:
comp_ch(plans = nh_m[, 3:5], shp = nh)

}
\concept{compactness}
