% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReportService.R
\name{dfp_runReportJob}
\alias{dfp_runReportJob}
\title{runReportJob}
\usage{
dfp_runReportJob(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a runReportJobResponse
}
\description{
Initiates the execution of a ReportQuery on the server.
The following fields are required: 
\itemize{
  \item{ReportJob reportQuery}
}
}
\examples{
\dontrun{
request_data <- list(reportJob=
                       list(reportQuery=
                              list(dimensions='MONTH_AND_YEAR', 
                                   dimensions='AD_UNIT_ID',
                                   adUnitView='FLAT',
                                   columns='AD_SERVER_CLICKS', 
                                   dateRangeType='LAST_WEEK')))

# the result is a list and most importantly the ID is included for checking its status
dfp_runReportJob_result <- dfp_runReportJob(request_data)
dfp_runReportJob_result$id
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/ReportService#runReportJob}{Google Documentation for runReportJob}
}
