% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExchangeRateService.R
\name{dfp_getExchangeRatesByStatement}
\alias{dfp_getExchangeRatesByStatement}
\title{getExchangeRatesByStatement}
\usage{
dfp_getExchangeRatesByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getExchangeRatesByStatementResponse
}
\description{
Gets a ExchangeRatePage of ExchangeRate objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{currencyCode}
  \item{refreshRate}
  \item{direction}
  \item{exchangeRate}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getExchangeRatesByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/ExchangeRateService#getExchangeRatesByStatement}{Google Documentation for getExchangeRatesByStatement}
}
