% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_articles_pdf.R
\name{core_articles_pdf}
\alias{core_articles_pdf}
\alias{core_articles_pdf_}
\title{Download article pdf}
\usage{
core_articles_pdf(id, key = NULL, overwrite = TRUE, parse = TRUE, ...)

core_articles_pdf_(id, key = NULL, overwrite = TRUE, ...)
}
\arguments{
\item{id}{(integer) CORE ID of the article that needs to be fetched.
Required}

\item{key}{A IUCN API token}

\item{overwrite}{(logical) overwrite file or not. Default: \code{TRUE}}

\item{parse}{(logical) Whether to parse to list (`FALSE`) or
data.frame (`TRUE`). Default: `TRUE`}

\item{...}{Curl options passed to [crul::HttpClient()]}
}
\description{
Download article pdf
}
\details{
\code{core_articles_history} does the HTTP request and parses, while
\code{core_articles_history_} just does the HTTP request, gives back JSON as
a character string

These functions take one article ID at a time. Use lapply/loops/etc for
many ids
}
\examples{
\dontrun{
# just http request, get file path back
core_articles_pdf_(11549557)

# get paper and parse to text
core_articles_pdf(11549557)

ids <- c(11549557, 385071)
res <- lapply(ids, core_articles_pdf)
vapply(res, "[[", "", 1)
}
}
\references{
\url{https://core.ac.uk/docs/#!/articles/getArticlePdfByCoreId}
}
