% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxonOneSampleR.r
\name{wilcoxonOneSampleR}
\alias{wilcoxonOneSampleR}
\title{r effect size for Wilcoxon one-sample signed-rank test}
\usage{
wilcoxonOneSampleR(
  x,
  mu = NULL,
  adjustn = TRUE,
  coin = FALSE,
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A vector of observations.}

\item{mu}{The value to compare \code{x} to, as in \code{wilcox.test}}

\item{adjustn}{If \code{TRUE}, reduces the sample size in the calculation
of \code{r} by the number of observations equal to
\code{mu}.}

\item{coin}{If \code{FALSE}, the default, the Z value
is extracted from a function similar to the
\code{wilcox.test} function in the stats package.
If \code{TRUE}, the Z value
is extracted from the \code{wilcox_test} function in the
coin package.  This method may be much slower, especially
if a confidence interval is produced.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{wilcoxsign_test} function.}
}
\value{
A single statistic, r.
        Or a small data frame consisting of r,
        and the lower and upper confidence limits.
}
\description{
Calculates r effect size
             for a Wilcoxon one-sample signed-rank test; 
             confidence intervals by bootstrap.
}
\details{
r  is calculated as Z divided by 
          square root of the number of observations.
          
          The calculated statistic is equivalent to the statistic returned
          by the \code{wilcoxPairedR} function with one group equal
          to a vector of \code{mu}.
          The author knows of no reference for this technique.
          
          This statistic typically reports a smaller effect size
          (in absolute value) than does
          the matched-pairs rank biserial correlation coefficient 
          (\code{wilcoxonOneSampleRC}), and may not reach a value
          of -1 or 1 if there are values tied with \code{mu}.
          
          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
          
          When the data are greater than \code{mu}, r is positive.
          When the data are less than \code{mu}, r is negative.
          
          When r is close to extremes,
          or with small counts in some cells,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\section{Acknowledgments}{

         My thanks to
         Peter Stikker for the suggestion to adjust the sample size
         for ties with \code{mu}.
}

\examples{
X = c(1,2,3,3,3,3,4,4,4,4,4,5,5,5,5,5)
wilcox.test(X, mu=3, exact=FALSE)
wilcoxonOneSampleR(X, mu=3)

}
\references{
\url{http://rcompanion.org/handbook/F_02.html}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{effect size ordinal nominal}
