% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseMedianTest.r
\name{pairwiseMedianTest}
\alias{pairwiseMedianTest}
\title{Pairwise Mood's median tests}
\usage{
pairwiseMedianTest(
  formula = NULL,
  data = NULL,
  x = NULL,
  g = NULL,
  digits = 4,
  method = "fdr",
  ...
)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{digits}{The number of significant digits to round output.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{stats::p.adjust}.}

\item{...}{Additional arguments passed to
code{coin::median_test}.}
}
\value{
A dataframe of the groups being compared, the p-values,
        and the adjusted p-values.
}
\description{
Conducts pairwise Mood's median tests across groups.
}
\details{
The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{g}.
         
         Mood's median test compares medians among two or more groups.
         See \url{http://rcompanion.org/handbook/F_09.html} for
         futher discussion of this test.

         The \code{pairwiseMedianTest} function
         can be used as a post-hoc method following an omnibus Mood's
         median test.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
data(PoohPiglet)
PoohPiglet$Speaker = factor(PoohPiglet$Speaker,
                     levels = c("Pooh", "Tigger", "Piglet"))
PT = pairwiseMedianTest(Likert ~ Speaker,
                        data   = PoohPiglet,
                        exact  = NULL,
                        method = "fdr")
PT                         
cldList(comparison = PT$Comparison,
        p.value    = PT$p.adjust,
        threshold  = 0.05)                         

}
\references{
\url{http://rcompanion.org/handbook/F_09.html}
}
\seealso{
\code{\link{pairwiseMedianMatrix}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{moods median nonparametric post-hoc one-way}
