% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseOrdinalTest.r
\name{pairwiseOrdinalTest}
\alias{pairwiseOrdinalTest}
\title{Pairwise two-sample ordinal regression}
\usage{
pairwiseOrdinalTest(x, g, method = "fdr", ...)
}
\arguments{
\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{\link{p.adjust}}.}

\item{...}{Additional arguments passed to
\code{\link{clm}}.}
}
\value{
A dataframe of the groups being compared, the p-values,
        and the adjusted p-values.
}
\description{
Performs pairwise two-sample ordinal regression across groups.
}
\details{
Ordinal regression 
         is analogous to general linear regression or generalized linear
         regression for cases where 
         the dependent variable
         is an ordinal variable.
         The \code{ordinal} package provides a flexible and powerful
         implementation of ordinal regression.
         
         The \code{pairwiseOrdinalTest} function 
         can be used as a post-hoc method following an omnibus 
         ordinal regession whose form is analogous to
         a one-way analysis of variance.
         
         The \code{x} variable must be an ordered factor.
}
\examples{
data(PoohPiglet)
PoohPiglet$Likert.f = factor(PoohPiglet$Likert, ordered = TRUE)
PoohPiglet = PoohPiglet[order(factor(PoohPiglet$Speaker, 
                        levels=c("Pooh", "Tigger", "Piglet"))),]
pairwiseOrdinalTest(x      = PoohPiglet$Likert.f,
                    g      = PoohPiglet$Speaker,
                    method = "fdr")

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/G_07.html}
}
\seealso{
\code{\link{pairwiseOrdinalMatrix}}
}
\concept{
ordinal regression post-hoc one-way
}

