/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.Axis;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.RealRange;

public class Real2Range
implements EuclidConstants {
    RealRange xrange;
    RealRange yrange;

    public Real2Range() {
    }

    public Real2Range(RealRange xr, RealRange yr) {
        if (xr.isValid() && yr.isValid()) {
            this.xrange = xr;
            this.yrange = yr;
        }
    }

    public Real2Range(Real2 r2a, Real2 r2b) {
        double x0 = r2a.getX();
        double x1 = r2b.getX();
        this.xrange = new RealRange(Math.min(x0, x1), Math.max(x0, x1));
        double y0 = r2a.getY();
        double y1 = r2b.getY();
        this.yrange = new RealRange(Math.min(y0, y1), Math.max(y0, y1));
    }

    public Real2Range(Real2Range r) {
        if (r.isValid()) {
            this.xrange = new RealRange(r.xrange);
            this.yrange = new RealRange(r.yrange);
        }
    }

    public boolean isValid() {
        return this.xrange != null && this.yrange != null && this.xrange.isValid() && this.yrange.isValid();
    }

    @Deprecated
    public boolean isEqualTo(Real2Range r2) {
        if (this.isValid() && r2 != null && r2.isValid()) {
            return this.xrange.isEqualTo(r2.xrange) && this.yrange.isEqualTo(r2.yrange);
        }
        return false;
    }

    public boolean isEqualTo(Real2Range r2, double eps) {
        if (this.isValid() && r2 != null && r2.isValid()) {
            return this.xrange.isEqualTo(r2.xrange, eps) && this.yrange.isEqualTo(r2.yrange, eps);
        }
        return false;
    }

    public Real2Range plus(Real2Range r2) {
        if (!this.isValid()) {
            if (r2 == null || !r2.isValid()) {
                return new Real2Range();
            }
            return new Real2Range(r2);
        }
        if (r2 == null || !r2.isValid()) {
            return new Real2Range(this);
        }
        return new Real2Range(this.xrange.plus(r2.xrange), this.yrange.plus(r2.yrange));
    }

    public Real2Range intersectionWith(Real2Range r2) {
        if (!this.isValid() || r2 == null || !r2.isValid()) {
            return new Real2Range();
        }
        RealRange xr = this.getXRange().intersectionWith(r2.getXRange());
        RealRange yr = this.getYRange().intersectionWith(r2.getYRange());
        return xr == null || yr == null ? null : new Real2Range(xr, yr);
    }

    public RealRange getXRange() {
        return this.xrange;
    }

    public RealRange getYRange() {
        return this.yrange;
    }

    public Real2 getCentroid() {
        return new Real2(this.xrange.getMidPoint(), this.yrange.getMidPoint());
    }

    public Real2[] getCorners() {
        Real2[] rr = new Real2[]{new Real2(this.xrange.getMin(), this.yrange.getMin()), new Real2(this.xrange.getMax(), this.yrange.getMax())};
        return rr;
    }

    public boolean includes(Real2 p) {
        if (!this.isValid()) {
            return false;
        }
        return this.xrange.includes(p.getX()) && this.yrange.includes(p.getY());
    }

    public boolean includes(Real2Range r) {
        if (!this.isValid() || r == null || !r.isValid()) {
            return false;
        }
        RealRange xr = r.getXRange();
        RealRange yr = r.getYRange();
        return this.xrange.includes(xr) && this.yrange.includes(yr);
    }

    public void add(Real2 p) {
        if (p == null) {
            return;
        }
        if (this.xrange == null) {
            this.xrange = new RealRange();
        }
        if (this.yrange == null) {
            this.yrange = new RealRange();
        }
        this.xrange.add(p.getX());
        this.yrange.add(p.getY());
    }

    public void add(Axis.Axis2 ax, RealRange range) {
        if (range == null) {
            return;
        }
        if (ax.equals((Object)Axis.Axis2.X)) {
            if (this.xrange == null) {
                this.xrange = new RealRange();
            }
            this.xrange = this.xrange.plus(range);
        }
        if (ax.equals((Object)Axis.Axis2.Y)) {
            if (this.yrange == null) {
                this.yrange = new RealRange();
            }
            this.yrange = this.yrange.plus(range);
        }
    }

    public Real2 distanceOutside(Real2 p) {
        Real2 r2 = null;
        if (p != null) {
            double dx = this.xrange.distanceOutside(p.getX());
            double dy = this.yrange.distanceOutside(p.getY());
            if (!Double.isNaN(dx) && !Double.isNaN(dy)) {
                r2 = new Real2(dx, dy);
            }
        }
        return r2;
    }

    public String toString() {
        String xx = this.xrange == null ? "NULL" : this.xrange.toString();
        String yy = this.yrange == null ? "NULL" : this.yrange.toString();
        return "(" + xx + "," + yy + ")";
    }
}

