/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.io.MDLV3000ReaderTest")
public class MDLV3000Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV3000Reader.class);
    private Pattern keyValueTuple;
    private Pattern keyValueTuple2;
    private int lineNumber;

    public MDLV3000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        this.mode = mode;
        this.keyValueTuple = Pattern.compile("\\s*(\\w+)=([^\\s]*)(.*)");
        this.keyValueTuple2 = Pattern.compile("\\s*(\\w+)=\\(([^\\)]*)\\)(.*)");
        this.lineNumber = 0;
    }

    public MDLV3000Reader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLV3000Reader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLV3000Format.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        this.lineNumber = 0;
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IAtomContainer) {
            return (T)this.readMolecule(object.getBuilder());
        }
        return null;
    }

    public IAtomContainer readMolecule(IChemObjectBuilder builder) throws CDKException {
        return (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[]{this.readConnectionTable(builder)});
    }

    public IAtomContainer readConnectionTable(IChemObjectBuilder builder) throws CDKException {
        logger.info((Object)"Reading CTAB block");
        IAtomContainer readData = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        boolean foundEND = false;
        String lastLine = this.readHeader(readData);
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(lastLine);
            logger.debug((Object)("command found: " + command));
            if ("END CTAB".equals(command)) {
                foundEND = true;
            } else if (!"BEGIN CTAB".equals(command) && !"COUNTS".equals(command)) {
                if ("BEGIN ATOM".equals(command)) {
                    this.readAtomBlock(readData);
                } else if ("BEGIN BOND".equals(command)) {
                    this.readBondBlock(readData);
                } else if ("BEGIN SGROUP".equals(command)) {
                    this.readSGroup(readData);
                } else {
                    logger.warn((Object)("Unrecognized command: " + command));
                }
            }
            lastLine = this.readLine();
        }
        return readData;
    }

    public String readHeader(IAtomContainer readData) throws CDKException {
        String line4;
        String line1 = this.readLine();
        if (line1 == null) {
            throw new CDKException("Expected a header line, but found nothing.");
        }
        if (line1.length() > 0) {
            if (line1.startsWith("M  V30")) {
                return line1;
            }
            readData.setProperty((Object)"cdk:Title", (Object)line1);
        }
        this.readLine();
        String line3 = this.readLine();
        if (line3.length() > 0) {
            readData.setProperty((Object)"cdk:Comment", (Object)line3);
        }
        if (!(line4 = this.readLine()).contains("3000")) {
            throw new CDKException("This file is not a MDL V3000 molfile.");
        }
        return this.readLine();
    }

    public void readAtomBlock(IAtomContainer readData) throws CDKException {
        Isotopes isotopeFactory;
        logger.info((Object)"Reading ATOM block");
        try {
            isotopeFactory = Isotopes.getInstance();
        }
        catch (IOException exception) {
            throw new CDKException("Could not initiate the IsotopeFactory.", (Throwable)exception);
        }
        int RGroupCounter = 1;
        int Rnumber = 0;
        String[] rGroup = null;
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(this.readLine());
            if ("END ATOM".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug((Object)("Parsing atom from: " + command));
            IAtom atom = (IAtom)readData.getBuilder().newInstance(IAtom.class, new Object[0]);
            StringTokenizer tokenizer = new StringTokenizer(command);
            try {
                atom.setID(tokenizer.nextToken());
            }
            catch (Exception exception) {
                String error = "Error while parsing atom index";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            String element = tokenizer.nextToken();
            if (isotopeFactory.isElement(element)) {
                atom = isotopeFactory.configure((IAtom)readData.getBuilder().newInstance(IAtom.class, new Object[]{element}));
            } else if ("A".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("Q".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("*".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("LP".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("L".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if (element.length() > 0 && element.charAt(0) == 'R') {
                logger.debug((Object)"Atom ", new Object[]{element, " is not an regular element. Creating a PseudoAtom."});
                rGroup = element.split("^R");
                if (rGroup.length > 1) {
                    try {
                        RGroupCounter = Rnumber = Integer.valueOf(rGroup[rGroup.length - 1]).intValue();
                    }
                    catch (Exception ex) {
                        Rnumber = RGroupCounter++;
                    }
                    element = "R" + Rnumber;
                }
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else {
                if (this.mode == IChemObjectReader.Mode.STRICT) {
                    throw new CDKException("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.");
                }
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
                atom.setSymbol(element);
            }
            try {
                String xString = tokenizer.nextToken();
                String yString = tokenizer.nextToken();
                String zString = tokenizer.nextToken();
                double x = Double.parseDouble(xString);
                double y = Double.parseDouble(yString);
                double z = Double.parseDouble(zString);
                atom.setPoint3d(new Point3d(x, y, z));
                atom.setPoint2d(new Point2d(x, y));
            }
            catch (Exception exception) {
                String error = "Error while parsing atom coordinates";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            String mapping = tokenizer.nextToken();
            if (!mapping.equals("0")) {
                logger.warn((Object)("Skipping atom-atom mapping: " + mapping));
            }
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        if (key.equals("CHG")) {
                            int charge = Integer.parseInt(value);
                            if (charge == 0) continue;
                            atom.setFormalCharge(Integer.valueOf(charge));
                            continue;
                        }
                        logger.warn((Object)("Not parsing key: " + key));
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error((Object)error);
                        logger.debug((Object)exception);
                        throw new CDKException(error, (Throwable)exception);
                    }
                }
            }
            readData.addAtom(atom);
            logger.debug((Object)("Added atom: " + atom));
        }
    }

    public void readBondBlock(IAtomContainer readData) throws CDKException {
        logger.info((Object)"Reading BOND block");
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(this.readLine());
            if ("END BOND".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug((Object)("Parsing bond from: " + command));
            StringTokenizer tokenizer = new StringTokenizer(command);
            IBond bond = (IBond)readData.getBuilder().newInstance(IBond.class, new Object[0]);
            try {
                String indexString = tokenizer.nextToken();
                bond.setID(indexString);
            }
            catch (Exception exception) {
                String error = "Error while parsing bond index";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            try {
                String orderString = tokenizer.nextToken();
                int order = Integer.parseInt(orderString);
                if (order >= 4) {
                    logger.warn((Object)"Query order types are not supported (yet). File a bug if you need it");
                } else {
                    bond.setOrder(BondManipulator.createBondOrder((double)order));
                }
            }
            catch (Exception exception) {
                String error = "Error while parsing bond index";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            try {
                String indexAtom1String = tokenizer.nextToken();
                int indexAtom1 = Integer.parseInt(indexAtom1String);
                IAtom atom1 = readData.getAtom(indexAtom1 - 1);
                bond.setAtom(atom1, 0);
            }
            catch (Exception exception) {
                String error = "Error while parsing index atom 1 in bond";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            try {
                String indexAtom2String = tokenizer.nextToken();
                int indexAtom2 = Integer.parseInt(indexAtom2String);
                IAtom atom2 = readData.getAtom(indexAtom2 - 1);
                bond.setAtom(atom2, 1);
            }
            catch (Exception exception) {
                String error = "Error while parsing index atom 2 in bond";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        if (key.equals("CFG")) {
                            int configuration = Integer.parseInt(value);
                            if (configuration == 0) {
                                bond.setStereo(IBond.Stereo.NONE);
                                continue;
                            }
                            if (configuration == 1) {
                                bond.setStereo(IBond.Stereo.UP);
                                continue;
                            }
                            if (configuration == 2) {
                                bond.setStereo((IBond.Stereo)CDKConstants.UNSET);
                                continue;
                            }
                            if (configuration != 3) continue;
                            bond.setStereo(IBond.Stereo.DOWN);
                            continue;
                        }
                        logger.warn((Object)("Not parsing key: " + key));
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error((Object)error);
                        logger.debug((Object)exception);
                        throw new CDKException(error, (Throwable)exception);
                    }
                }
            }
            readData.addBond(bond);
            logger.debug((Object)("Added bond: " + bond));
        }
    }

    public void readSGroup(IAtomContainer readData) throws CDKException {
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(this.readLine());
            if ("END SGROUP".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug((Object)("Parsing Sgroup line: " + command));
            StringTokenizer tokenizer = new StringTokenizer(command);
            String indexString = tokenizer.nextToken();
            logger.warn((Object)("Skipping external index: " + indexString));
            String type = tokenizer.nextToken();
            String externalIndexString = tokenizer.nextToken();
            logger.warn((Object)("Skipping external index: " + externalIndexString));
            Map<Object, Object> options = new Hashtable();
            if (command.indexOf(61) != -1) {
                options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
            }
            if (type.startsWith("SUP")) {
                Iterator keys = options.keySet().iterator();
                int atomID = -1;
                String label = "";
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = (String)options.get(key);
                    try {
                        if (key.equals("ATOMS")) {
                            StringTokenizer atomsTokenizer = new StringTokenizer(value);
                            Integer.parseInt(atomsTokenizer.nextToken());
                            atomID = Integer.parseInt(atomsTokenizer.nextToken());
                        } else if (key.equals("LABEL")) {
                            label = value;
                        } else {
                            logger.warn((Object)("Not parsing key: " + key));
                        }
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error((Object)error);
                        logger.debug((Object)exception);
                        throw new CDKException(error, (Throwable)exception);
                    }
                    if (atomID == -1 || label.length() <= 0) continue;
                    IAtom atom = readData.getAtom(atomID - 1);
                    if (!(atom instanceof IPseudoAtom)) {
                        atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{atom});
                    }
                    ((IPseudoAtom)atom).setLabel(label);
                    readData.setAtom(atomID - 1, atom);
                }
                continue;
            }
            logger.warn((Object)("Skipping unrecognized SGROUP type: " + type));
        }
    }

    private String readCommand(String line) throws CDKException {
        if (line.startsWith("M  V30 ")) {
            String command = line.substring(7);
            if (command.endsWith("-")) {
                command = command.substring(0, command.length() - 1);
                command = command + this.readCommand(this.readLine());
            }
            return command;
        }
        throw new CDKException("Could not read MDL file: unexpected line: " + line);
    }

    private Map<String, String> parseOptions(String string) throws CDKException {
        Hashtable<String, String> keyValueTuples = new Hashtable<String, String>();
        while (string.length() >= 3) {
            logger.debug((Object)("Matching remaining option string: " + string));
            Matcher tuple1Matcher = this.keyValueTuple2.matcher(string);
            if (tuple1Matcher.matches()) {
                String key = tuple1Matcher.group(1);
                String value = tuple1Matcher.group(2);
                string = tuple1Matcher.group(3);
                logger.debug((Object)("Found key: " + key));
                logger.debug((Object)("Found value: " + value));
                keyValueTuples.put(key, value);
                continue;
            }
            Matcher tuple2Matcher = this.keyValueTuple.matcher(string);
            if (tuple2Matcher.matches()) {
                String key = tuple2Matcher.group(1);
                String value = tuple2Matcher.group(2);
                string = tuple2Matcher.group(3);
                logger.debug((Object)("Found key: " + key));
                logger.debug((Object)("Found value: " + value));
                keyValueTuples.put(key, value);
                continue;
            }
            logger.warn((Object)("Quiting; could not parse: " + string + "."));
            string = "";
        }
        return keyValueTuples;
    }

    public String exhaustStringTokenizer(StringTokenizer tokenizer) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public String readLine() throws CDKException {
        String line = null;
        try {
            line = this.input.readLine();
            ++this.lineNumber;
            logger.debug((Object)("read line " + this.lineNumber + ":"), new Object[]{line});
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
        return line;
    }

    public boolean isReady() throws CDKException {
        try {
            return this.input.ready();
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
    }
}

