/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

@TestClass(value="org.openscience.cdk.renderer.generators.ReactionPlusGeneratorTest")
public class ReactionPlusGenerator
implements IGenerator<IReaction> {
    @TestMethod(value="testEmptyReaction")
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        IAtomContainerSet products;
        double axis;
        ElementGroup diagram = new ElementGroup();
        Color color = (Color)((BasicSceneGenerator.ForegroundColor)model.getParameter(BasicSceneGenerator.ForegroundColor.class)).getValue();
        IAtomContainerSet reactants = reaction.getReactants();
        if (reactants.getAtomContainerCount() > 1) {
            Rectangle2D totalBoundsReactants = BoundsCalculator.calculateBounds((IAtomContainerSet)reactants);
            Rectangle2D bounds1 = BoundsCalculator.calculateBounds((IAtomContainer)reactants.getAtomContainer(0));
            axis = totalBoundsReactants.getCenterY();
            for (int i = 1; i < reaction.getReactantCount(); ++i) {
                Rectangle2D bounds2 = BoundsCalculator.calculateBounds((IAtomContainer)reactants.getAtomContainer(i));
                diagram.add((IRenderingElement)this.makePlus(bounds1, bounds2, axis, color));
                bounds1 = bounds2;
            }
        }
        if ((products = reaction.getProducts()).getAtomContainerCount() > 1) {
            Rectangle2D totalBoundsProducts = BoundsCalculator.calculateBounds((IAtomContainerSet)products);
            axis = totalBoundsProducts.getCenterY();
            Rectangle2D bounds1 = BoundsCalculator.calculateBounds((IAtomContainer)reactants.getAtomContainer(0));
            for (int i = 1; i < reaction.getProductCount(); ++i) {
                Rectangle2D bounds2 = BoundsCalculator.calculateBounds((IAtomContainer)products.getAtomContainer(i));
                diagram.add((IRenderingElement)this.makePlus(bounds1, bounds2, axis, color));
                bounds1 = bounds2;
            }
        }
        return diagram;
    }

    private TextElement makePlus(Rectangle2D moleculeBox1, Rectangle2D moleculeBox2, double axis, Color color) {
        double arrowCenter = (moleculeBox1.getCenterX() + moleculeBox2.getCenterX()) / 2.0;
        return new TextElement(arrowCenter, axis, "+", color);
    }

    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[0]);
    }
}

