/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;

@TestClass(value="org.openscience.cdk.tools.manipulator.ReactionManipulatorTest")
public class ReactionManipulator {
    @TestMethod(value="testGetAtomCount_IReaction")
    public static int getAtomCount(IReaction reaction) {
        int count = 0;
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            count += reactants.getAtomContainer(i).getAtomCount();
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            count += products.getAtomContainer(i).getAtomCount();
        }
        return count;
    }

    @TestMethod(value="testGetBondCount_IReaction")
    public static int getBondCount(IReaction reaction) {
        int count = 0;
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            count += reactants.getAtomContainer(i).getBondCount();
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            count += products.getAtomContainer(i).getBondCount();
        }
        return count;
    }

    @TestMethod(value="testRemoveAtomAndConnectedElectronContainers_IReaction_IAtom")
    public static void removeAtomAndConnectedElectronContainers(IReaction reaction, IAtom atom) {
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtomAndConnectedElectronContainers(atom);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtomAndConnectedElectronContainers(atom);
        }
    }

    @TestMethod(value="testRemoveElectronContainer_IReaction_IElectronContainer")
    public static void removeElectronContainer(IReaction reaction, IElectronContainer electrons) {
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
    }

    @TestMethod(value="testGetAllMolecules_IReaction")
    public static IAtomContainerSet getAllMolecules(IReaction reaction) {
        IAtomContainerSet moleculeSet = (IAtomContainerSet)reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        moleculeSet.add(ReactionManipulator.getAllReactants(reaction));
        moleculeSet.add(ReactionManipulator.getAllProducts(reaction));
        return moleculeSet;
    }

    @TestMethod(value="testGetAllProducts_IReaction")
    public static IAtomContainerSet getAllProducts(IReaction reaction) {
        IAtomContainerSet moleculeSet = (IAtomContainerSet)reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            moleculeSet.addAtomContainer(products.getAtomContainer(i));
        }
        return moleculeSet;
    }

    @TestMethod(value="testGetAllReactants_IReaction")
    public static IAtomContainerSet getAllReactants(IReaction reaction) {
        IAtomContainerSet moleculeSet = (IAtomContainerSet)reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            moleculeSet.addAtomContainer(reactants.getAtomContainer(i));
        }
        return moleculeSet;
    }

    @TestMethod(value="testReverse_IReaction")
    public static IReaction reverse(IReaction reaction) {
        IReaction reversedReaction = (IReaction)reaction.getBuilder().newInstance(IReaction.class, new Object[0]);
        if (reaction.getDirection() == IReaction.Direction.BIDIRECTIONAL) {
            reversedReaction.setDirection(IReaction.Direction.BIDIRECTIONAL);
        } else if (reaction.getDirection() == IReaction.Direction.FORWARD) {
            reversedReaction.setDirection(IReaction.Direction.BACKWARD);
        } else if (reaction.getDirection() == IReaction.Direction.BACKWARD) {
            reversedReaction.setDirection(IReaction.Direction.FORWARD);
        }
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            double coefficient = reaction.getReactantCoefficient(reactants.getAtomContainer(i));
            reversedReaction.addProduct(reactants.getAtomContainer(i), Double.valueOf(coefficient));
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            double coefficient = reaction.getProductCoefficient(products.getAtomContainer(i));
            reversedReaction.addReactant(products.getAtomContainer(i), Double.valueOf(coefficient));
        }
        return reversedReaction;
    }

    @TestMethod(value="testGetAllAtomContainers_IReaction")
    public static List<IAtomContainer> getAllAtomContainers(IReaction reaction) {
        return MoleculeSetManipulator.getAllAtomContainers(ReactionManipulator.getAllMolecules(reaction));
    }

    @TestMethod(value="testGetAllIDs_IReaction")
    public static List<String> getAllIDs(IReaction reaction) {
        ArrayList<String> idList = new ArrayList<String>();
        if (reaction.getID() != null) {
            idList.add(reaction.getID());
        }
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        return idList;
    }

    @TestMethod(value="testGetRelevantAtomContainer_IReaction_IAtom")
    public static IAtomContainer getRelevantAtomContainer(IReaction reaction, IAtom atom) {
        IAtomContainer result = MoleculeSetManipulator.getRelevantAtomContainer(reaction.getReactants(), atom);
        if (result != null) {
            return result;
        }
        return MoleculeSetManipulator.getRelevantAtomContainer(reaction.getProducts(), atom);
    }

    @TestMethod(value="testGetRelevantAtomContainer_IReaction_IBond")
    public static IAtomContainer getRelevantAtomContainer(IReaction reaction, IBond bond) {
        IAtomContainer result = MoleculeSetManipulator.getRelevantAtomContainer(reaction.getReactants(), bond);
        if (result != null) {
            return result;
        }
        return MoleculeSetManipulator.getRelevantAtomContainer(reaction.getProducts(), bond);
    }

    @TestMethod(value="testSetAtomProperties_IReactionSet_Object_Object")
    public static void setAtomProperties(IReaction reaction, Object propKey, Object propVal) {
        IAtomContainerSet reactants = reaction.getReactants();
        for (int j = 0; j < reactants.getAtomContainerCount(); ++j) {
            AtomContainerManipulator.setAtomProperties(reactants.getAtomContainer(j), propKey, propVal);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int j = 0; j < products.getAtomContainerCount(); ++j) {
            AtomContainerManipulator.setAtomProperties(products.getAtomContainer(j), propKey, propVal);
        }
    }

    @TestMethod(value="testGetAllChemObjects_IReactionSet")
    public static List<IChemObject> getAllChemObjects(IReaction reaction) {
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        list.add((IChemObject)reaction);
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            list.add((IChemObject)reactants.getAtomContainer(i));
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            list.add((IChemObject)products.getAtomContainer(i));
        }
        return list;
    }

    @TestMethod(value="testGetMappedChemObject_IReaction_IAtom,testGetMappedChemObject_IReaction_IBond")
    public static IChemObject getMappedChemObject(IReaction reaction, IChemObject chemObject) {
        for (IMapping mapping : reaction.mappings()) {
            if (mapping.getChemObject(0).equals(chemObject)) {
                return mapping.getChemObject(1);
            }
            if (!mapping.getChemObject(1).equals(chemObject)) continue;
            return mapping.getChemObject(0);
        }
        return null;
    }
}

