/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.bond;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.GasteigerPEPEPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractBondDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.bond.BondPartialPiChargeDescriptorTest")
public class BondPartialPiChargeDescriptor
extends AbstractBondDescriptor {
    private GasteigerPEPEPartialCharges pepe = new GasteigerPEPEPartialCharges();
    private int maxIterations = -1;
    private int maxResonStruc = -1;
    private boolean lpeChecker = true;
    private static final String[] descriptorNames = new String[]{"pepeB"};

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondPartialPiCharge", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 3) {
            throw new CDKException("PartialPiChargeDescriptor only expects three parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
        if (params.length > 1 && params[1] != null) {
            if (!(params[1] instanceof Boolean)) {
                throw new CDKException("The parameter must be of type Boolean");
            }
            this.lpeChecker = (Boolean)params[1];
        }
        if (params.length > 2 && params[2] != null) {
            if (!(params[2] instanceof Integer)) {
                throw new CDKException("The parameter must be of type Integer");
            }
            this.maxResonStruc = (Integer)params[2];
        }
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations, this.lpeChecker, this.maxResonStruc};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return descriptorNames;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), descriptorNames, e);
    }

    @TestMethod(value="testCalculate_IBond_IAtomContainer,testBondPiElectronegativityDescriptor,testBondPiElectronegativityDescriptor_Allyl_bromide")
    public DescriptorValue calculate(IBond bond, IAtomContainer ac) {
        Double originalCharge1 = bond.getAtom(0).getCharge();
        String originalAtomtypeName1 = bond.getAtom(0).getAtomTypeName();
        Integer originalNeighborCount1 = bond.getAtom(0).getFormalNeighbourCount();
        IAtomType.Hybridization originalHybridization1 = bond.getAtom(0).getHybridization();
        Integer originalValency1 = bond.getAtom(0).getValency();
        Double originalCharge2 = bond.getAtom(1).getCharge();
        String originalAtomtypeName2 = bond.getAtom(1).getAtomTypeName();
        Integer originalNeighborCount2 = bond.getAtom(1).getFormalNeighbourCount();
        IAtomType.Hybridization originalHybridization2 = bond.getAtom(1).getHybridization();
        Integer originalValency2 = bond.getAtom(1).getValency();
        Double originalBondOrderSum1 = bond.getAtom(0).getBondOrderSum();
        IBond.Order originalMaxBondOrder1 = bond.getAtom(0).getMaxBondOrder();
        Double originalBondOrderSum2 = bond.getAtom(1).getBondOrderSum();
        IBond.Order originalMaxBondOrder2 = bond.getAtom(1).getMaxBondOrder();
        if (!this.isCachedAtomContainer(ac)) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)ac);
                if (this.lpeChecker) {
                    LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                    lpcheck.saturate(ac);
                }
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue((Exception)((Object)e));
            }
            if (this.maxIterations != -1) {
                this.pepe.setMaxGasteigerIters(this.maxIterations);
            }
            if (this.maxResonStruc != -1) {
                this.pepe.setMaxResoStruc(this.maxResonStruc);
            }
            try {
                for (int i = 0; i < ac.getAtomCount(); ++i) {
                    ac.getAtom(i).setCharge(Double.valueOf(0.0));
                }
                this.pepe.assignGasteigerPiPartialCharges(ac, true);
                for (IBond bondi : ac.bonds()) {
                    double result = Math.abs(bondi.getAtom(0).getCharge() - bondi.getAtom(1).getCharge());
                    this.cacheDescriptorValue(bondi, ac, (IDescriptorResult)new DoubleResult(result));
                }
            }
            catch (Exception ex1) {
                return this.getDummyDescriptorValue(ex1);
            }
        }
        bond.getAtom(0).setCharge(originalCharge1);
        bond.getAtom(0).setAtomTypeName(originalAtomtypeName1);
        bond.getAtom(0).setHybridization(originalHybridization1);
        bond.getAtom(0).setValency(originalValency1);
        bond.getAtom(0).setFormalNeighbourCount(originalNeighborCount1);
        bond.getAtom(1).setCharge(originalCharge2);
        bond.getAtom(1).setAtomTypeName(originalAtomtypeName2);
        bond.getAtom(1).setHybridization(originalHybridization2);
        bond.getAtom(1).setValency(originalValency2);
        bond.getAtom(1).setFormalNeighbourCount(originalNeighborCount2);
        bond.getAtom(0).setMaxBondOrder(originalMaxBondOrder1);
        bond.getAtom(0).setBondOrderSum(originalBondOrderSum1);
        bond.getAtom(1).setMaxBondOrder(originalMaxBondOrder2);
        bond.getAtom(1).setBondOrderSum(originalBondOrderSum2);
        return this.getCachedDescriptorValue(bond) != null ? new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), this.getCachedDescriptorValue(bond), descriptorNames) : null;
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations", "lpeChecker", "maxResonStruc"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        if ("maxIterations".equals(name)) {
            return Integer.MAX_VALUE;
        }
        if ("lpeChecker".equals(name)) {
            return Boolean.TRUE;
        }
        if ("maxResonStruc".equals(name)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }
}

