/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.List;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Hybridization {
    Unknown,
    Sp,
    Sp2,
    Sp3,
    Sp3d,
    Sp3d2,
    Sp3d3;

    private static Hybridization[] map;

    static Hybridization[] hybridizations(Graph g) {
        boolean changed;
        int ord = g.order();
        Hybridization[] hs = new Hybridization[ord];
        for (int u = 0; u < ord; ++u) {
            hs[u] = Hybridization.hybridization(g, u);
        }
        do {
            changed = false;
            for (int u = 0; u < ord; ++u) {
                if (hs[u] == Sp2 || Hybridization.lonePairs(g, u) <= 0 || !Hybridization.attachedToSp2(hs, g, u)) continue;
                hs[u] = Sp2;
                changed = true;
            }
        } while (changed);
        return hs;
    }

    static Hybridization hybridization(Graph g, int u) {
        Atom atom = g.atom(u);
        if (!atom.element().aromatic()) {
            return Unknown;
        }
        int v = Hybridization.valence(atom.element());
        int x = Hybridization.monovalant(g.edges(u)) + g.implHCount(u);
        int c = atom.charge() > 0 ? atom.charge() : 0;
        int a = atom.charge() < 0 ? -atom.charge() : 0;
        return Hybridization.hybridization(v, x, c, a);
    }

    static Hybridization hybridization(int v, int x, int c, int a) {
        return map[(v + x - c + a) / 2];
    }

    static int monovalant(List<Edge> es) {
        int x = 0;
        for (Edge e : es) {
            if (e.bond() != Bond.SINGLE && e.bond() != Bond.IMPLICIT) continue;
            ++x;
        }
        return x;
    }

    static boolean attachedToSp2(Hybridization[] hs, Graph g, int u) {
        for (Edge e : g.edges(u)) {
            if (hs[e.other(u)] != Sp2) continue;
            return true;
        }
        return false;
    }

    static int valence(Element e) {
        switch (e) {
            case Boron: {
                return 3;
            }
            case Carbon: 
            case Silicon: 
            case Germanium: 
            case Tin: {
                return 4;
            }
            case Nitrogen: 
            case Phosphorus: 
            case Arsenic: 
            case Antimony: {
                return 5;
            }
            case Oxygen: 
            case Sulfur: 
            case Selenium: 
            case Tellurium: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unsupported element " + (Object)((Object)e));
    }

    static int lonePairs(Graph g, int u) {
        Atom atom = g.atom(u);
        if (!atom.element().aromatic()) {
            return 0;
        }
        int sum = g.implHCount(u);
        List<Edge> es = g.edges(u);
        for (Edge e : es) {
            sum += e.bond().order();
        }
        int v = Hybridization.valence(g.atom(u).element()) + -atom.charge();
        return (v - sum) / 2;
    }

    static {
        map = new Hybridization[]{Unknown, Unknown, Sp, Sp2, Sp3, Sp3d, Sp3d2, Sp3d3};
    }
}

