/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class ChemObject
implements Serializable,
IChemObject,
Cloneable {
    private static final long serialVersionUID = 2798134548764323328L;
    private Map<Object, Object> properties;
    private short flags;
    private String identifier;
    private boolean doNotification = true;

    public ChemObject() {
        this.properties = null;
        this.identifier = null;
    }

    public ChemObject(IChemObject chemObject) {
        this.flags = chemObject.getFlagValue().shortValue();
        this.identifier = chemObject.getID();
    }

    public void addListener(IChemObjectListener col) {
    }

    public int getListenerCount() {
        return 0;
    }

    public void removeListener(IChemObjectListener col) {
    }

    public void notifyChanged() {
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<Object, Object>();
        }
        return this.properties;
    }

    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
    }

    public void removeProperty(Object description) {
        if (this.properties == null) {
            return;
        }
        this.lazyProperties().remove(description);
    }

    public <T> T getProperty(Object description) {
        if (this.properties == null) {
            return null;
        }
        Object value = this.lazyProperties().get(description);
        return (T)value;
    }

    @TestMethod(value="testGetProperty_Object_Class,testGetProperty_Object_ClassCast")
    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.lazyProperties().get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    public Map<Object, Object> getProperties() {
        return this.lazyProperties();
    }

    public Object clone() throws CloneNotSupportedException {
        ChemObject clone = (ChemObject)super.clone();
        clone.flags = this.getFlagValue();
        if (this.properties != null) {
            clone.properties = new HashMap<Object, Object>(this.getProperties());
        }
        return clone;
    }

    public boolean compare(Object object) {
        if (!(object instanceof IChemObject)) {
            return false;
        }
        ChemObject chemObj = (ChemObject)object;
        return Objects.equal((Object)this.identifier, (Object)chemObj.identifier);
    }

    public String getID() {
        return this.identifier;
    }

    public void setID(String identifier) {
        this.identifier = identifier;
    }

    public void setFlag(int mask, boolean value) {
        this.flags = value ? (short)(this.flags | mask) : (short)(this.flags & ~mask);
    }

    public boolean getFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public Short getFlagValue() {
        return this.flags;
    }

    public void setProperties(Map<Object, Object> properties) {
        this.properties = null;
        if (properties != null) {
            this.addProperties(properties);
        }
    }

    public void addProperties(Map<Object, Object> properties) {
        if (properties == null) {
            return;
        }
        this.lazyProperties().putAll(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        for (int i = 0; i < flagsNew.length; ++i) {
            this.setFlag(CDKConstants.FLAG_MASKS[i], flagsNew[i]);
        }
    }

    public boolean[] getFlags() {
        boolean[] flagArray = new boolean[14];
        for (int i = 0; i < CDKConstants.FLAG_MASKS.length; ++i) {
            int mask = CDKConstants.FLAG_MASKS[i];
            flagArray[i] = this.getFlag(mask);
        }
        return flagArray;
    }

    public Object shallowCopy() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return copy;
    }

    public IChemObjectBuilder getBuilder() {
        return SilentChemObjectBuilder.getInstance();
    }

    public void setNotification(boolean bool) {
        this.doNotification = bool;
    }

    public boolean getNotification() {
        return this.doNotification;
    }
}

