/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.BitMatrix;
import org.openscience.cdk.graph.GreedyBasis;
import org.openscience.cdk.graph.InitialCycles;
import org.openscience.cdk.graph.RelevantCycles;

@TestClass(value="org.openscience.cdk.graph.EssentialCyclesTest")
public final class EssentialCycles {
    private final List<InitialCycles.Cycle> essential;
    private final InitialCycles initial;
    private final GreedyBasis basis;

    public EssentialCycles(int[][] graph) {
        this(new InitialCycles(graph));
    }

    EssentialCycles(InitialCycles initial) {
        this(new RelevantCycles(initial), initial);
    }

    EssentialCycles(RelevantCycles relevant, InitialCycles initial) {
        Preconditions.checkNotNull((Object)relevant, (Object)"No RelevantCycles provided");
        this.initial = (InitialCycles)Preconditions.checkNotNull((Object)initial, (Object)"No InitialCycles provided");
        this.basis = new GreedyBasis(initial.numberOfCycles(), initial.numberOfEdges());
        this.essential = new ArrayList<InitialCycles.Cycle>();
        for (List<InitialCycles.Cycle> cycles : this.groupByLength(relevant)) {
            for (InitialCycles.Cycle c : this.membersOfBasis(cycles)) {
                if (!this.isEssential(c, cycles)) continue;
                this.essential.add(c);
            }
        }
    }

    @TestMethod(value="paths_bicyclo,paths_napthalene,paths_anthracene,paths_cyclophane_odd,paths_cyclophane_even")
    public int[][] paths() {
        int[][] paths = new int[this.size()][];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.essential.get(i).path();
        }
        return paths;
    }

    @TestMethod(value="size_bicyclo,size_napthalene,size_anthracene,size_cyclophane_odd,size_cyclophane_even")
    public int size() {
        return this.essential.size();
    }

    private List<List<InitialCycles.Cycle>> groupByLength(RelevantCycles relevant) {
        LinkedList<List<InitialCycles.Cycle>> cyclesByLength = new LinkedList<List<InitialCycles.Cycle>>();
        for (int[] path : relevant.paths()) {
            if (cyclesByLength.isEmpty() || path.length > cyclesByLength.getLast().get(0).path().length) {
                cyclesByLength.add(new ArrayList());
            }
            cyclesByLength.getLast().add(new MyCycle(path));
        }
        return cyclesByLength;
    }

    private List<InitialCycles.Cycle> membersOfBasis(List<InitialCycles.Cycle> cycles) {
        int start = this.basis.size();
        for (InitialCycles.Cycle c : cycles) {
            if (!this.basis.isIndependent(c)) continue;
            this.basis.add(c);
        }
        return this.basis.members().subList(start, this.basis.size());
    }

    private boolean isEssential(InitialCycles.Cycle candidate, Collection<InitialCycles.Cycle> relevant) {
        ArrayList<InitialCycles.Cycle> alternate = new ArrayList<InitialCycles.Cycle>(relevant.size() + this.basis.size());
        int weight = candidate.length();
        for (InitialCycles.Cycle cycle : this.basis.members()) {
            if (cycle.length() >= weight) continue;
            alternate.add(cycle);
        }
        for (InitialCycles.Cycle cycle : relevant) {
            if (cycle.equals(candidate)) continue;
            alternate.add(cycle);
        }
        return BitMatrix.from(alternate).eliminate() < this.basis.size();
    }

    private class MyCycle
    extends InitialCycles.Cycle {
        private MyCycle(int[] path) {
            super(null, path);
        }

        @Override
        BitSet edges(int[] path) {
            return EssentialCycles.this.initial.toEdgeVector(path);
        }

        @Override
        int[][] family() {
            return new int[][]{this.path()};
        }

        @Override
        int sizeOfFamily() {
            return 1;
        }

        public String toString() {
            return Arrays.toString(this.path());
        }
    }
}

