/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.List;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;

final class FromSubsetAtoms
extends AbstractFunction<Graph, Graph> {
    FromSubsetAtoms() {
    }

    @Override
    public Graph apply(Graph g) {
        Graph h = new Graph(g.order());
        for (int u = 0; u < g.order(); ++u) {
            h.addAtom(FromSubsetAtoms.fromSubset(g.atom(u), this.bondOrderSum(g.edges(u), g), g.degree(u)));
            h.addTopology(g.topologyOf(u));
        }
        for (Edge e : g.edges()) {
            h.addEdge(e);
        }
        return h;
    }

    private int bondOrderSum(List<Edge> es, Graph g) {
        int sum = 0;
        for (Edge e : es) {
            sum += e.bond().order();
        }
        return sum;
    }

    static Atom fromSubset(Atom a, int sum, int deg) {
        if (!a.subset()) {
            return a;
        }
        Element e = a.element();
        if (a.aromatic()) {
            ++sum;
        }
        int hCount = a.aromatic() ? e.aromaticImplicitHydrogens(sum) : e.implicitHydrogens(sum);
        return new AtomImpl.BracketAtom(-1, a.element(), hCount, 0, 0, a.aromatic());
    }
}

