/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.silent.ElectronContainer;

public class Bond
extends ElectronContainer
implements IBond,
Serializable,
Cloneable {
    private static final long serialVersionUID = 7057060562283387384L;
    protected IBond.Order order = (IBond.Order)((Object)CDKConstants.UNSET);
    protected int atomCount = 0;
    protected IAtom[] atoms = null;
    protected IBond.Stereo stereo;

    public Bond() {
        this(null, null, null, IBond.Stereo.NONE);
        this.atomCount = 0;
    }

    public Bond(IAtom atom1, IAtom atom2) {
        this(atom1, atom2, IBond.Order.SINGLE, IBond.Stereo.NONE);
    }

    public Bond(IAtom atom1, IAtom atom2, IBond.Order order) {
        this(atom1, atom2, order, IBond.Stereo.NONE);
    }

    public Bond(IAtom[] atoms) {
        this.atoms = new IAtom[atoms.length];
        System.arraycopy(atoms, 0, this.atoms, 0, atoms.length);
        this.atomCount = this.atoms.length;
    }

    public Bond(IAtom[] atoms, IBond.Order order) {
        this.atoms = new IAtom[atoms.length];
        System.arraycopy(atoms, 0, this.atoms, 0, atoms.length);
        this.atomCount = this.atoms.length;
        this.order = order;
    }

    public Bond(IAtom atom1, IAtom atom2, IBond.Order order, IBond.Stereo stereo) {
        this.atoms = new IAtom[2];
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.setOrder(order);
        this.stereo = stereo;
        this.atomCount = 2;
    }

    @Override
    public Iterable<IAtom> atoms() {
        return new Iterable<IAtom>(){

            @Override
            public Iterator<IAtom> iterator() {
                return new AtomsIterator();
            }
        };
    }

    @Override
    public void setAtoms(IAtom[] atoms) {
        this.atoms = atoms;
        this.atomCount = atoms.length;
    }

    @Override
    public int getAtomCount() {
        return this.atomCount;
    }

    @Override
    public IAtom getAtom(int position) {
        if (this.atoms == null) {
            return null;
        }
        return this.atoms[position];
    }

    @Override
    public IAtom getConnectedAtom(IAtom atom) {
        if (this.atoms[0] == atom) {
            return this.atoms[1];
        }
        if (this.atoms[1] == atom) {
            return this.atoms[0];
        }
        return null;
    }

    @Override
    public IAtom[] getConnectedAtoms(IAtom atom) {
        boolean atomIsInBond = false;
        for (IAtom localAtom : this.atoms) {
            if (localAtom != atom) continue;
            atomIsInBond = true;
            break;
        }
        if (!atomIsInBond) {
            return null;
        }
        ArrayList<IAtom> conAtoms = new ArrayList<IAtom>();
        for (IAtom localAtom : this.atoms) {
            if (localAtom == atom) continue;
            conAtoms.add(localAtom);
        }
        return conAtoms.toArray(new IAtom[0]);
    }

    @Override
    public boolean contains(IAtom atom) {
        if (this.atoms == null) {
            return false;
        }
        for (IAtom localAtom : this.atoms) {
            if (localAtom != atom) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setAtom(IAtom atom, int position) {
        if (this.atoms[position] == null && atom != null) {
            ++this.atomCount;
        }
        if (this.atoms[position] != null && atom == null) {
            --this.atomCount;
        }
        this.atoms[position] = atom;
    }

    @Override
    public IBond.Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(IBond.Order order) {
        this.order = order;
        if (order != null) {
            switch (order) {
                case SINGLE: {
                    this.electronCount = 2;
                    break;
                }
                case DOUBLE: {
                    this.electronCount = 4;
                    break;
                }
                case TRIPLE: {
                    this.electronCount = 6;
                    break;
                }
                case QUADRUPLE: {
                    this.electronCount = 8;
                    break;
                }
                default: {
                    this.electronCount = 0;
                }
            }
        }
    }

    @Override
    public IBond.Stereo getStereo() {
        return this.stereo;
    }

    @Override
    public void setStereo(IBond.Stereo stereo) {
        this.stereo = stereo;
    }

    @Override
    public Point2d get2DCenter() {
        double xOfCenter = 0.0;
        double yOfCenter = 0.0;
        for (IAtom atom : this.atoms) {
            xOfCenter += atom.getPoint2d().x;
            yOfCenter += atom.getPoint2d().y;
        }
        return new Point2d(xOfCenter / (double)this.getAtomCount(), yOfCenter / (double)this.getAtomCount());
    }

    @Override
    public Point3d get3DCenter() {
        double xOfCenter = 0.0;
        double yOfCenter = 0.0;
        double zOfCenter = 0.0;
        for (IAtom atom : this.atoms) {
            xOfCenter += atom.getPoint3d().x;
            yOfCenter += atom.getPoint3d().y;
            zOfCenter += atom.getPoint3d().z;
        }
        return new Point3d(xOfCenter / (double)this.getAtomCount(), yOfCenter / (double)this.getAtomCount(), zOfCenter / (double)this.getAtomCount());
    }

    @Override
    public boolean compare(Object object) {
        if (object instanceof IBond) {
            Bond bond = (Bond)object;
            for (IAtom atom : this.atoms) {
                if (bond.contains(atom)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnectedTo(IBond bond) {
        for (IAtom atom : this.atoms) {
            if (!bond.contains(atom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IBond clone() throws CloneNotSupportedException {
        Bond clone = (Bond)super.clone();
        if (this.atoms != null) {
            clone.atoms = new IAtom[this.atoms.length];
            for (int f = 0; f < this.atoms.length; ++f) {
                if (this.atoms[f] == null) continue;
                clone.atoms[f] = this.atoms[f].clone();
            }
        }
        return clone;
    }

    @Override
    public String toString() {
        StringBuffer resultString = new StringBuffer(32);
        resultString.append("Bond(").append(this.hashCode());
        if (this.getOrder() != null) {
            resultString.append(", #O:").append((Object)this.getOrder());
        }
        resultString.append(", #S:").append((Object)this.getStereo());
        if (this.getAtomCount() > 0) {
            resultString.append(", #A:").append(this.getAtomCount());
            for (int i = 0; i < this.atomCount; ++i) {
                resultString.append(", ").append("" + this.atoms[i]);
            }
        }
        resultString.append(", ").append(super.toString());
        resultString.append(')');
        return resultString.toString();
    }

    private class AtomsIterator
    implements Iterator<IAtom> {
        private int pointer = 0;

        private AtomsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < Bond.this.atomCount;
        }

        @Override
        public IAtom next() {
            ++this.pointer;
            return Bond.this.atoms[this.pointer - 1];
        }

        @Override
        public void remove() {
        }
    }
}

