/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import java.util.List;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.JniInchiWrapper;
import net.sf.jniinchi.LoadNativeLibraryException;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

@TestClass(value="org.openscience.cdk.inchi.InChIGeneratorFactoryTest")
public class InChIGeneratorFactory {
    private static InChIGeneratorFactory INSTANCE;
    private boolean ignoreAromaticBonds = true;

    private InChIGeneratorFactory() throws CDKException {
        try {
            JniInchiWrapper.loadLibrary();
        }
        catch (LoadNativeLibraryException lnle) {
            throw new CDKException("Unable to load native code; " + lnle.getMessage(), lnle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestMethod(value="testGetInstance")
    public static InChIGeneratorFactory getInstance() throws CDKException {
        Class<InChIGeneratorFactory> clazz = InChIGeneratorFactory.class;
        synchronized (InChIGeneratorFactory.class) {
            if (INSTANCE == null) {
                INSTANCE = new InChIGeneratorFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Deprecated
    @TestMethod(value="testInChIGenerator_AromaticBonds")
    public void setIgnoreAromaticBonds(boolean ignore) {
        this.ignoreAromaticBonds = ignore;
    }

    @Deprecated
    @TestMethod(value="testInChIGenerator_AromaticBonds")
    public boolean getIgnoreAromaticBonds() {
        return this.ignoreAromaticBonds;
    }

    @TestMethod(value="testGetInChIGenerator_IAtomContainer")
    public InChIGenerator getInChIGenerator(IAtomContainer container) throws CDKException {
        return new InChIGenerator(container, this.ignoreAromaticBonds);
    }

    @TestMethod(value="testGetInChIGenerator_IAtomContainer_String")
    public InChIGenerator getInChIGenerator(IAtomContainer container, String options) throws CDKException {
        return new InChIGenerator(container, options, this.ignoreAromaticBonds);
    }

    @TestMethod(value="testGetInChIGenerator_IAtomContainer_List")
    public InChIGenerator getInChIGenerator(IAtomContainer container, List<INCHI_OPTION> options) throws CDKException {
        return new InChIGenerator(container, options, this.ignoreAromaticBonds);
    }

    @TestMethod(value="testGetInChIToStructure_String_IChemObjectBuilder")
    public InChIToStructure getInChIToStructure(String inchi, IChemObjectBuilder builder) throws CDKException {
        return new InChIToStructure(inchi, builder);
    }

    @TestMethod(value="testGetInChIToStructure_String_IChemObjectBuilder_NullString")
    public InChIToStructure getInChIToStructure(String inchi, IChemObjectBuilder builder, String options) throws CDKException {
        return new InChIToStructure(inchi, builder, options);
    }

    @TestMethod(value="testGetInChIToStructure_String_IChemObjectBuilder_List")
    public InChIToStructure getInChIToStructure(String inchi, IChemObjectBuilder builder, List<String> options) throws CDKException {
        return new InChIToStructure(inchi, builder, options);
    }
}

