/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import com.google.common.base.Preconditions;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.GreedyBasis;
import org.openscience.cdk.graph.InitialCycles;

@TestClass(value="org.openscience.cdk.graph.MinimumCycleBasisTest")
public final class MinimumCycleBasis {
    private final GreedyBasis basis;
    final int[][] graph;

    @TestMethod(value="noGraph")
    public MinimumCycleBasis(int[][] graph) {
        this(new InitialCycles(Preconditions.checkNotNull(graph, "No graph provided")));
    }

    @TestMethod(value="noInitialCycles")
    MinimumCycleBasis(InitialCycles initial) {
        this(initial, false);
    }

    @TestMethod(value="noInitialCycles")
    MinimumCycleBasis(InitialCycles initial, boolean connected) {
        Preconditions.checkNotNull(initial, "No InitialCycles provided");
        this.graph = initial.graph();
        this.basis = new GreedyBasis(initial.numberOfCycles(), initial.numberOfEdges());
        int lim = connected ? initial.numberOfEdges() - this.graph.length + 1 : Integer.MAX_VALUE;
        for (InitialCycles.Cycle cycle : initial.cycles()) {
            if (this.basis.size() >= lim || !this.basis.isIndependent(cycle)) continue;
            this.basis.add(cycle);
        }
    }

    @TestMethod(value="paths_bicyclo,paths_napthalene,paths_anthracene,paths_cyclophane_odd,paths_cyclophane_even")
    public int[][] paths() {
        int[][] paths = new int[this.size()][0];
        int i = 0;
        for (InitialCycles.Cycle c : this.basis.members()) {
            paths[i++] = c.path();
        }
        return paths;
    }

    @TestMethod(value="size_bicyclo,size_napthalene,size_anthracene,size_cyclophane_odd,size_cyclophane_even")
    public int size() {
        return this.basis.size();
    }
}

