/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip.rules;

import java.io.IOException;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.rules.ISequenceSubRule;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.geometry.cip.rules.MassNumberRuleTest")
class MassNumberRule
implements ISequenceSubRule<ILigand> {
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(MassNumberRule.class);
    IsotopeFactory factory;

    MassNumberRule() {
    }

    @Override
    @TestMethod(value="testCompare_Identity,testCompare,testOrder")
    public int compare(ILigand ligand1, ILigand ligand2) {
        this.ensureFactory(ligand1);
        return this.getMassNumber(ligand1).compareTo(this.getMassNumber(ligand2));
    }

    private void ensureFactory(ILigand ligand) {
        if (this.factory == null) {
            try {
                this.factory = Isotopes.getInstance();
            }
            catch (IOException exception) {
                this.logger.error("Could not load the IsotopeFactory: " + exception.getMessage());
            }
        }
    }

    private Integer getMassNumber(ILigand ligand) {
        Integer massNumber = ligand.getLigandAtom().getMassNumber();
        if (massNumber != null) {
            return massNumber;
        }
        if (this.factory == null) {
            return 0;
        }
        return this.factory.getMajorIsotope(ligand.getLigandAtom().getSymbol()).getMassNumber();
    }
}

