/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles.smarts.parser.visitor;

import java.util.ArrayList;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.AliphaticAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AliphaticSymbolAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyOrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticOrSingleQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticSymbolAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AtomicNumberAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.ChiralityAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.ExplicitConnectionAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.FormalChargeAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.HybridizationNumberAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.HydrogenAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.ImplicitHCountAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.LogicalOperatorAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.LogicalOperatorBond;
import org.openscience.cdk.isomorphism.matchers.smarts.MassAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.NonCHHeavyAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.OrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.PeriodicGroupNumberAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.RecursiveSmartsAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.RingBond;
import org.openscience.cdk.isomorphism.matchers.smarts.RingIdentifierAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.RingMembershipAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSBond;
import org.openscience.cdk.isomorphism.matchers.smarts.SmallestRingAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.StereoBond;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalConnectionAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalHCountAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalRingConnectionAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalValencyAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTAliphatic;
import org.openscience.cdk.smiles.smarts.parser.ASTAnyAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTAromatic;
import org.openscience.cdk.smiles.smarts.parser.ASTAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTAtomicMass;
import org.openscience.cdk.smiles.smarts.parser.ASTAtomicNumber;
import org.openscience.cdk.smiles.smarts.parser.ASTCharge;
import org.openscience.cdk.smiles.smarts.parser.ASTChirality;
import org.openscience.cdk.smiles.smarts.parser.ASTElement;
import org.openscience.cdk.smiles.smarts.parser.ASTExplicitAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTExplicitConnectivity;
import org.openscience.cdk.smiles.smarts.parser.ASTExplicitHighAndBond;
import org.openscience.cdk.smiles.smarts.parser.ASTExplicitHighAndExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTGroup;
import org.openscience.cdk.smiles.smarts.parser.ASTHybrdizationNumber;
import org.openscience.cdk.smiles.smarts.parser.ASTImplicitHCount;
import org.openscience.cdk.smiles.smarts.parser.ASTImplicitHighAndBond;
import org.openscience.cdk.smiles.smarts.parser.ASTImplicitHighAndExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTLowAndBond;
import org.openscience.cdk.smiles.smarts.parser.ASTLowAndExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTNonCHHeavyAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTNotBond;
import org.openscience.cdk.smiles.smarts.parser.ASTNotExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTOrBond;
import org.openscience.cdk.smiles.smarts.parser.ASTOrExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTPeriodicGroupNumber;
import org.openscience.cdk.smiles.smarts.parser.ASTReaction;
import org.openscience.cdk.smiles.smarts.parser.ASTRecursiveSmartsExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTRingConnectivity;
import org.openscience.cdk.smiles.smarts.parser.ASTRingIdentifier;
import org.openscience.cdk.smiles.smarts.parser.ASTRingMembership;
import org.openscience.cdk.smiles.smarts.parser.ASTSimpleBond;
import org.openscience.cdk.smiles.smarts.parser.ASTSmallestRingSize;
import org.openscience.cdk.smiles.smarts.parser.ASTSmarts;
import org.openscience.cdk.smiles.smarts.parser.ASTStart;
import org.openscience.cdk.smiles.smarts.parser.ASTTotalConnectivity;
import org.openscience.cdk.smiles.smarts.parser.ASTTotalHCount;
import org.openscience.cdk.smiles.smarts.parser.ASTValence;
import org.openscience.cdk.smiles.smarts.parser.Node;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParserVisitor;
import org.openscience.cdk.smiles.smarts.parser.SimpleNode;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class SmartsQueryVisitor
implements SMARTSParserVisitor {
    private RingIdentifierAtom[] ringAtoms;
    private RingIdentifierAtom[] recursiveRingAtoms;
    private IQueryAtomContainer query;
    private boolean isParsingRS;
    private IQueryAtomContainer rsQuery;
    private final IChemObjectBuilder builder;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(SmartsQueryVisitor.class);

    public SmartsQueryVisitor(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    public Object visit(ASTRingIdentifier node, Object data) {
        IQueryAtom atom = (IQueryAtom)data;
        RingIdentifierAtom ringIdAtom = new RingIdentifierAtom(this.builder);
        ringIdAtom.setAtom(atom);
        IQueryBond bond = node.jjtGetNumChildren() == 0 ? null : (IQueryBond)node.jjtGetChild(0).jjtAccept(this, data);
        ringIdAtom.setRingBond(bond);
        return ringIdAtom;
    }

    public Object visit(ASTAtom node, Object data) {
        IQueryAtom atom = (IQueryAtom)node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            IQueryBond ringBond;
            ASTRingIdentifier ringIdentifier = (ASTRingIdentifier)node.jjtGetChild(i);
            RingIdentifierAtom ringIdAtom = (RingIdentifierAtom)ringIdentifier.jjtAccept(this, atom);
            int ringId = ringIdentifier.getRingId();
            if (this.isParsingRS) {
                if (this.recursiveRingAtoms[ringId] == null) {
                    this.recursiveRingAtoms[ringId] = ringIdAtom;
                } else {
                    ringBond = this.recursiveRingAtoms[ringId].getRingBond() == null ? (ringIdAtom.getRingBond() == null ? (atom instanceof AromaticSymbolAtom && this.recursiveRingAtoms[ringId].getAtom() instanceof AromaticSymbolAtom ? new AromaticQueryBond(this.builder) : new RingBond(this.builder)) : ringIdAtom.getRingBond()) : this.recursiveRingAtoms[ringId].getRingBond();
                    ringBond.setAtoms(new IAtom[]{this.recursiveRingAtoms[ringId].getAtom(), atom});
                    this.rsQuery.addBond(ringBond);
                }
                this.recursiveRingAtoms[ringId] = ringIdAtom;
                continue;
            }
            if (this.ringAtoms[ringId] == null) {
                this.ringAtoms[ringId] = ringIdAtom;
            } else {
                ringBond = this.ringAtoms[ringId].getRingBond() == null ? (ringIdAtom.getRingBond() == null ? (atom instanceof AromaticSymbolAtom && this.ringAtoms[ringId].getAtom() instanceof AromaticSymbolAtom ? new AromaticQueryBond(this.builder) : new RingBond(this.builder)) : ringIdAtom.getRingBond()) : this.ringAtoms[ringId].getRingBond();
                ringBond.setAtoms(new IAtom[]{this.ringAtoms[ringId].getAtom(), atom});
                this.query.addBond(ringBond);
            }
            this.ringAtoms[ringId] = ringIdAtom;
        }
        return atom;
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public Object visit(ASTStart node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTReaction node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTGroup node, Object data) {
        ArrayList<IQueryAtomContainer> atomContainers = new ArrayList<IQueryAtomContainer>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            this.ringAtoms = new RingIdentifierAtom[10];
            this.query = new QueryAtomContainer(this.builder);
            node.jjtGetChild(i).jjtAccept(this, null);
            atomContainers.add(this.query);
        }
        logger.info("Only return the first smarts. Group not supported.");
        return atomContainers.get(0);
    }

    public Object visit(ASTSmarts node, Object data) {
        SMARTSAtom atom = null;
        SMARTSBond bond = null;
        ASTAtom first = (ASTAtom)node.jjtGetChild(0);
        atom = (SMARTSAtom)first.jjtAccept(this, null);
        if (data != null) {
            bond = (SMARTSBond)((Object[])data)[1];
            if (bond == null) {
                bond = new AromaticOrSingleQueryBond(this.builder);
                bond.setAtoms(new IAtom[]{atom, (SMARTSAtom)((Object[])data)[0]});
            } else {
                bond.setAtoms(new IAtom[]{(SMARTSAtom)((Object[])data)[0], atom});
            }
            if (this.isParsingRS) {
                this.rsQuery.addBond(bond);
            } else {
                this.query.addBond(bond);
            }
            bond = null;
        }
        if (this.isParsingRS) {
            this.rsQuery.addAtom(atom);
        } else {
            this.query.addAtom(atom);
        }
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            Node child = node.jjtGetChild(i);
            if (child instanceof ASTLowAndBond) {
                bond = (SMARTSBond)child.jjtAccept(this, data);
                continue;
            }
            if (child instanceof ASTAtom) {
                SMARTSAtom newAtom = (SMARTSAtom)child.jjtAccept(this, null);
                if (bond == null) {
                    bond = new AromaticOrSingleQueryBond(this.builder);
                }
                bond.setAtoms(new IAtom[]{atom, newAtom});
                if (this.isParsingRS) {
                    this.rsQuery.addBond(bond);
                    this.rsQuery.addAtom(newAtom);
                } else {
                    this.query.addBond(bond);
                    this.query.addAtom(newAtom);
                }
                atom = newAtom;
                bond = null;
                continue;
            }
            if (!(child instanceof ASTSmarts)) continue;
            child.jjtAccept(this, new Object[]{atom, bond});
            bond = null;
        }
        return this.isParsingRS ? this.rsQuery : this.query;
    }

    public Object visit(ASTNotBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.getType() == 5) {
            LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
            bond.setOperator("not");
            bond.setLeft((IQueryBond)left);
            return bond;
        }
        return left;
    }

    public Object visit(ASTImplicitHighAndBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
        bond.setOperator("and");
        bond.setLeft((IQueryBond)left);
        IQueryBond right = (IQueryBond)node.jjtGetChild(1).jjtAccept(this, data);
        bond.setRight(right);
        return bond;
    }

    public Object visit(ASTLowAndBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
        bond.setOperator("and");
        bond.setLeft((IQueryBond)left);
        IQueryBond right = (IQueryBond)node.jjtGetChild(1).jjtAccept(this, data);
        bond.setRight(right);
        return bond;
    }

    public Object visit(ASTOrBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
        bond.setOperator("or");
        bond.setLeft((IQueryBond)left);
        IQueryBond right = (IQueryBond)node.jjtGetChild(1).jjtAccept(this, data);
        bond.setRight(right);
        return bond;
    }

    public Object visit(ASTExplicitHighAndBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
        bond.setOperator("and");
        bond.setLeft((IQueryBond)left);
        IQueryBond right = (IQueryBond)node.jjtGetChild(1).jjtAccept(this, data);
        bond.setRight(right);
        return bond;
    }

    public Object visit(ASTSimpleBond node, Object data) {
        SMARTSBond bond = null;
        switch (node.getBondType()) {
            case 6: {
                bond = new OrderQueryBond(IBond.Order.SINGLE, this.builder);
                break;
            }
            case 11: {
                bond = new OrderQueryBond(IBond.Order.DOUBLE, this.builder);
                break;
            }
            case 12: {
                bond = new OrderQueryBond(IBond.Order.TRIPLE, this.builder);
                break;
            }
            case 14: {
                bond = new AnyOrderQueryBond(this.builder);
                break;
            }
            case 13: {
                bond = new AromaticQueryBond(this.builder);
                break;
            }
            case 15: {
                bond = new RingBond(this.builder);
                break;
            }
            case 7: {
                bond = new StereoBond(this.builder);
                bond.setOrder(IBond.Order.SINGLE);
                bond.setStereo(IBond.Stereo.UP);
                break;
            }
            case 8: {
                bond = new StereoBond(this.builder);
                bond.setOrder(IBond.Order.SINGLE);
                bond.setStereo(IBond.Stereo.DOWN);
                break;
            }
            case 9: {
                LogicalOperatorBond logical = new LogicalOperatorBond(this.builder);
                logical.setOperator("or");
                StereoBond bond1 = new StereoBond(this.builder);
                bond1.setOrder(IBond.Order.SINGLE);
                bond1.setStereo(IBond.Stereo.UP);
                logical.setLeft(bond1);
                StereoBond bond2 = new StereoBond(this.builder);
                bond2.setOrder(IBond.Order.SINGLE);
                bond2.setStereo((IBond.Stereo)((Object)CDKConstants.UNSET));
                logical.setRight(bond2);
                bond = logical;
                break;
            }
            case 10: {
                LogicalOperatorBond logical = new LogicalOperatorBond(this.builder);
                logical.setOperator("or");
                StereoBond bond1 = new StereoBond(this.builder);
                bond1.setOrder(IBond.Order.SINGLE);
                bond1.setStereo(IBond.Stereo.DOWN);
                logical.setLeft(bond1);
                StereoBond bond2 = new StereoBond(this.builder);
                bond2.setOrder(IBond.Order.SINGLE);
                bond2.setStereo((IBond.Stereo)((Object)CDKConstants.UNSET));
                logical.setRight(bond2);
                bond = logical;
                break;
            }
            default: {
                logger.error("Un parsed bond: " + node.toString());
            }
        }
        return bond;
    }

    public Object visit(ASTRecursiveSmartsExpression node, Object data) {
        this.rsQuery = new QueryAtomContainer(this.builder);
        this.recursiveRingAtoms = new RingIdentifierAtom[10];
        this.isParsingRS = true;
        node.jjtGetChild(0).jjtAccept(this, null);
        this.isParsingRS = false;
        return new RecursiveSmartsAtom(this.rsQuery);
    }

    public ASTStart getRoot(Node node) {
        if (node instanceof ASTStart) {
            return (ASTStart)node;
        }
        return this.getRoot(node.jjtGetParent());
    }

    public Object visit(ASTElement node, Object data) {
        SMARTSAtom atom;
        String symbol = node.getSymbol();
        if ("o".equals(symbol) || "n".equals(symbol) || "c".equals(symbol) || "s".equals(symbol) || "p".equals(symbol) || "as".equals(symbol) || "se".equals(symbol)) {
            String atomSymbol = symbol.substring(0, 1).toUpperCase() + symbol.substring(1);
            atom = new AromaticSymbolAtom(atomSymbol, this.builder);
        } else {
            atom = new AliphaticSymbolAtom(symbol, this.builder);
        }
        return atom;
    }

    public Object visit(ASTTotalHCount node, Object data) {
        return new TotalHCountAtom(node.getCount(), this.builder);
    }

    public Object visit(ASTImplicitHCount node, Object data) {
        return new ImplicitHCountAtom(node.getCount(), this.builder);
    }

    public Object visit(ASTExplicitConnectivity node, Object data) {
        return new ExplicitConnectionAtom(node.getNumOfConnection(), this.builder);
    }

    public Object visit(ASTAtomicNumber node, Object data) {
        return new AtomicNumberAtom(node.getNumber(), this.builder);
    }

    public Object visit(ASTHybrdizationNumber node, Object data) {
        return new HybridizationNumberAtom(node.getHybridizationNumber(), this.builder);
    }

    public Object visit(ASTCharge node, Object data) {
        if (node.isPositive()) {
            return new FormalChargeAtom(node.getCharge(), this.builder);
        }
        return new FormalChargeAtom(0 - node.getCharge(), this.builder);
    }

    public Object visit(ASTRingConnectivity node, Object data) {
        return new TotalRingConnectionAtom(node.getNumOfConnection(), this.builder);
    }

    public Object visit(ASTPeriodicGroupNumber node, Object data) {
        return new PeriodicGroupNumberAtom(node.getGroupNumber(), this.builder);
    }

    public Object visit(ASTTotalConnectivity node, Object data) {
        return new TotalConnectionAtom(node.getNumOfConnection(), this.builder);
    }

    public Object visit(ASTValence node, Object data) {
        return new TotalValencyAtom(node.getOrder(), this.builder);
    }

    public Object visit(ASTRingMembership node, Object data) {
        return new RingMembershipAtom(node.getNumOfMembership(), this.builder);
    }

    public Object visit(ASTSmallestRingSize node, Object data) {
        return new SmallestRingAtom(node.getSize(), this.builder);
    }

    public Object visit(ASTAliphatic node, Object data) {
        return new AliphaticAtom(this.builder);
    }

    public Object visit(ASTNonCHHeavyAtom node, Object data) {
        return new NonCHHeavyAtom(this.builder);
    }

    public Object visit(ASTAromatic node, Object data) {
        return new AromaticAtom(this.builder);
    }

    public Object visit(ASTAnyAtom node, Object data) {
        return new AnyAtom(this.builder);
    }

    public Object visit(ASTAtomicMass node, Object data) {
        return new MassAtom(node.getMass(), this.builder);
    }

    public Object visit(ASTChirality node, Object data) {
        ChiralityAtom atom = new ChiralityAtom(this.builder);
        atom.setDegree(node.getDegree());
        atom.setClockwise(node.isClockwise());
        atom.setUnspecified(node.isUnspecified());
        return atom;
    }

    public Object visit(ASTLowAndExpression node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorAtom atom = new LogicalOperatorAtom(this.builder);
        atom.setOperator("and");
        atom.setLeft((IQueryAtom)left);
        IQueryAtom right = (IQueryAtom)node.jjtGetChild(1).jjtAccept(this, data);
        atom.setRight(right);
        return atom;
    }

    public Object visit(ASTOrExpression node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorAtom atom = new LogicalOperatorAtom(this.builder);
        atom.setOperator("or");
        atom.setLeft((IQueryAtom)left);
        IQueryAtom right = (IQueryAtom)node.jjtGetChild(1).jjtAccept(this, data);
        atom.setRight(right);
        return atom;
    }

    public Object visit(ASTNotExpression node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.getType() == 5) {
            LogicalOperatorAtom atom = new LogicalOperatorAtom(this.builder);
            atom.setOperator("not");
            atom.setLeft((IQueryAtom)left);
            return atom;
        }
        return left;
    }

    public Object visit(ASTExplicitHighAndExpression node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorAtom atom = new LogicalOperatorAtom(this.builder);
        atom.setOperator("and");
        atom.setLeft((IQueryAtom)left);
        IQueryAtom right = (IQueryAtom)node.jjtGetChild(1).jjtAccept(this, data);
        atom.setRight(right);
        return atom;
    }

    public Object visit(ASTImplicitHighAndExpression node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorAtom atom = new LogicalOperatorAtom(this.builder);
        atom.setOperator("and");
        atom.setLeft((IQueryAtom)left);
        IQueryAtom right = (IQueryAtom)node.jjtGetChild(1).jjtAccept(this, data);
        atom.setRight(right);
        return atom;
    }

    public Object visit(ASTExplicitAtom node, Object data) {
        SMARTSAtom atom = null;
        String symbol = node.getSymbol();
        if ("*".equals(symbol)) {
            atom = new AnyAtom(this.builder);
        } else if ("A".equals(symbol)) {
            atom = new AliphaticAtom(this.builder);
        } else if ("a".equals(symbol)) {
            atom = new AromaticAtom(this.builder);
        } else if ("o".equals(symbol) || "n".equals(symbol) || "c".equals(symbol) || "s".equals(symbol) || "p".equals(symbol) || "as".equals(symbol) || "se".equals(symbol)) {
            String atomSymbol = symbol.substring(0, 1).toUpperCase() + symbol.substring(1);
            atom = new AromaticSymbolAtom(atomSymbol, this.builder);
        } else if ("H".equals(symbol)) {
            atom = new HydrogenAtom(this.builder);
            atom.setSymbol(symbol.toUpperCase());
            atom.setMassNumber(1);
        } else if ("D".equals(symbol)) {
            atom = new HydrogenAtom(this.builder);
            atom.setSymbol(symbol.toUpperCase());
            atom.setMassNumber(2);
        } else if ("T".equals(symbol)) {
            atom = new HydrogenAtom(this.builder);
            atom.setSymbol(symbol.toUpperCase());
            atom.setMassNumber(3);
        } else {
            atom = new AliphaticSymbolAtom(symbol, this.builder);
        }
        return atom;
    }
}

