/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.reaction.type.ElectronImpactNBEReactionTest")
public class ElectronImpactNBEReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ElectronImpactNBEReaction.class);

    @TestMethod(value="testGetSpecification")
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#ElectronImpactNBE", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @TestMethod(value="testInitiate_IAtomContainerSet_IAtomContainerSet")
    public IReactionSet initiate(IAtomContainerSet reactants, IAtomContainerSet agents) throws CDKException {
        logger.debug("initiate reaction: ElectronImpactNBEReaction");
        if (reactants.getAtomContainerCount() != 1) {
            throw new CDKException("ElectronImpactNBEReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("ElectronImpactNBEReaction don't expects agents");
        }
        IReactionSet setOfReactions = reactants.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IAtomContainer reactant = reactants.getAtomContainer(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        for (IAtom atom : reactant.atoms()) {
            if (!atom.getFlag(1024) || reactant.getConnectedLonePairsCount(atom) <= 0 || reactant.getConnectedSingleElectronsCount(atom) != 0) continue;
            ArrayList<IAtom> atomList = new ArrayList<IAtom>();
            atomList.add(atom);
            IAtomContainerSet moleculeSet = reactant.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            moleculeSet.addAtomContainer(reactant);
            IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, null);
            if (reaction == null) continue;
            setOfReactions.addReaction(reaction);
        }
        return setOfReactions;
    }

    private void setActiveCenters(IAtomContainer reactant) throws CDKException {
        for (IAtom atom : reactant.atoms()) {
            if (reactant.getConnectedLonePairsCount(atom) <= 0 || reactant.getConnectedSingleElectronsCount(atom) != 0) continue;
            atom.setFlag(1024, true);
        }
    }
}

