/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.TPSADescriptorTest")
public class TPSADescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static HashMap map;
    private static final String[] names;

    public TPSADescriptor() {
        if (map == null) {
            map = new HashMap();
            map.put("N+1.0+3.0+3+0+0+0+0+3+0+0", new Double(3.24));
            map.put("N+2.0+3.0+2+0+0+0+0+1+1+0", new Double(12.36));
            map.put("N+3.0+3.0+1+0+0+0+0+0+0+1", new Double(23.79));
            map.put("N+2.0+5.0+3+0+0+0+0+1+2+0", new Double(11.68));
            map.put("N+3.0+5.0+2+0+0+0+0+0+1+1", new Double(13.6));
            map.put("N+1.0+3.0+3+0+0+0+1+3+0+0", new Double(3.01));
            map.put("N+1.0+3.0+3+1+0+0+0+3+0+0", new Double(12.03));
            map.put("N+1.0+3.0+3+1+0+0+1+3+0+0", new Double(21.94));
            map.put("N+2.0+3.0+2+1+0+0+0+1+1+0", new Double(23.85));
            map.put("N+1.0+3.0+3+2+0+0+0+3+0+0", new Double(26.02));
            map.put("N+1.0+4.0+4+0+1+0+0+4+0+0", new Double(0.0));
            map.put("N+2.0+4.0+3+0+1+0+0+2+1+0", new Double(3.01));
            map.put("N+3.0+4.0+2+0+1+0+0+1+0+1", new Double(4.36));
            map.put("N+1.0+4.0+4+1+1+0+0+4+0+0", new Double(4.44));
            map.put("N+2.0+4.0+3+1+1+0+0+2+1+0", new Double(13.97));
            map.put("N+1.0+4.0+4+2+1+0+0+4+0+0", new Double(16.61));
            map.put("N+2.0+4.0+3+2+1+0+0+2+1+0", new Double(25.59));
            map.put("N+1.0+4.0+4+3+1+0+0+4+0+0", new Double(27.64));
            map.put("N+1.5+3.0+2+0+0+2+0+0+0+0", new Double(12.89));
            map.put("N+1.5+4.5+3+0+0+3+0+0+0+0", new Double(4.41));
            map.put("N+1.5+4.0+3+0+0+2+0+1+0+0", new Double(4.93));
            map.put("N+2.0+5.0+3+0+0+2+0+0+1+0", new Double(8.39));
            map.put("N+1.5+4.0+3+1+0+2+0+1+0+0", new Double(15.79));
            map.put("N+1.5+4.5+3+0+1+3+0+0+0+0", new Double(4.1));
            map.put("N+1.5+4.0+3+0+1+2+0+1+0+0", new Double(3.88));
            map.put("N+1.5+4.0+3+1+1+2+0+1+0+0", new Double(14.14));
            map.put("O+1.0+2.0+2+0+0+0+0+2+0+0", new Double(9.23));
            map.put("O+1.0+2.0+2+0+0+0+1+2+0+0", new Double(12.53));
            map.put("O+2.0+2.0+1+0+0+0+0+0+1+0", new Double(17.07));
            map.put("O+1.0+1.0+1+0+-1+0+0+1+0+0", new Double(23.06));
            map.put("O+1.0+2.0+2+1+0+0+0+2+0+0", new Double(20.23));
            map.put("O+1.5+3.0+2+0+0+2+0+0+0+0", new Double(13.14));
            map.put("S+1.0+2.0+2+0+0+0+0+2+0+0", new Double(25.3));
            map.put("S+2.0+2.0+1+0+0+0+0+0+1+0", new Double(32.09));
            map.put("S+2.0+4.0+3+0+0+0+0+2+1+0", new Double(19.21));
            map.put("S+2.0+6.0+4+0+0+0+0+2+2+0", new Double(8.38));
            map.put("S+1.0+2.0+2+1+0+0+0+2+0+0", new Double(38.8));
            map.put("S+1.5+3.0+2+0+0+2+0+0+0+0", new Double(28.24));
            map.put("S+2.0+5.0+3+0+0+2+0+0+1+0", new Double(21.7));
            map.put("P+1.0+3.0+3+0+0+0+0+3+0+0", new Double(13.59));
            map.put("P+2.0+3.0+3+0+0+0+0+1+1+0", new Double(34.14));
            map.put("P+2.0+5.0+4+0+0+0+0+3+1+0", new Double(9.81));
            map.put("P+2.0+5.0+4+1+0+0+0+3+1+0", new Double(23.47));
        }
    }

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#tpsa", this.getClass().getName(), "$Id: 8240e230ff02830bcc7c4d103f9991c4f13adac1 $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("TPSADescriptor expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IRingSet rs;
        IAtomContainer ac;
        try {
            ac = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        ArrayList<String> profiles = new ArrayList<String>();
        try {
            rs = new AllRingsFinder().findAllRings(ac);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(e);
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac);
                CDKHueckelAromaticityDetector.detectAromaticity(ac);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        for (IAtom atom : ac.atoms()) {
            if (!atom.getSymbol().equals("N") && !atom.getSymbol().equals("O") && !atom.getSymbol().equals("S") && !atom.getSymbol().equals("P")) continue;
            int singleBondCount = 0;
            int doubleBondCount = 0;
            int tripleBondCount = 0;
            int aromaticBondCount = 0;
            double maxBondOrder = 0.0;
            double bondOrderSum = 0.0;
            int hCount = 0;
            int isIn3MemberRing = 0;
            List<IBond> connectedBonds = ac.getConnectedBondsList(atom);
            for (IBond connectedBond : connectedBonds) {
                if (connectedBond.getFlag(32)) {
                    ++aromaticBondCount;
                    continue;
                }
                if (connectedBond.getOrder() == CDKConstants.BONDORDER_SINGLE) {
                    ++singleBondCount;
                    continue;
                }
                if (connectedBond.getOrder() == CDKConstants.BONDORDER_DOUBLE) {
                    ++doubleBondCount;
                    continue;
                }
                if (connectedBond.getOrder() != CDKConstants.BONDORDER_TRIPLE) continue;
                ++tripleBondCount;
            }
            int formalCharge = atom.getFormalCharge();
            List<IAtom> connectedAtoms = ac.getConnectedAtomsList(atom);
            int numberOfNeighbours = connectedAtoms.size();
            for (int neighbourIndex = 0; neighbourIndex < numberOfNeighbours; ++neighbourIndex) {
                if (!connectedAtoms.get(neighbourIndex).getSymbol().equals("H")) continue;
                ++hCount;
            }
            Integer implicitHAtoms = atom.getImplicitHydrogenCount();
            if (implicitHAtoms == CDKConstants.UNSET) {
                implicitHAtoms = 0;
            }
            for (int hydrogenIndex = 0; hydrogenIndex < implicitHAtoms; ++hydrogenIndex) {
                ++hCount;
                ++numberOfNeighbours;
                ++singleBondCount;
            }
            bondOrderSum += (double)singleBondCount * 1.0;
            bondOrderSum += (double)doubleBondCount * 2.0;
            bondOrderSum += (double)tripleBondCount * 3.0;
            bondOrderSum += (double)aromaticBondCount * 1.5;
            if (singleBondCount > 0) {
                maxBondOrder = 1.0;
            }
            if (aromaticBondCount > 0) {
                maxBondOrder = 1.5;
            }
            if (doubleBondCount > 0) {
                maxBondOrder = 2.0;
            }
            if (tripleBondCount > 0) {
                maxBondOrder = 3.0;
            }
            if (rs.contains(atom)) {
                IRingSet rsAtom = rs.getRings(atom);
                for (int ringSetIndex = 0; ringSetIndex < rsAtom.getAtomContainerCount(); ++ringSetIndex) {
                    IRing ring = (IRing)rsAtom.getAtomContainer(ringSetIndex);
                    if (ring.getRingSize() != 3) continue;
                    isIn3MemberRing = 1;
                }
            }
            String profile = atom.getSymbol() + "+" + maxBondOrder + "+" + bondOrderSum + "+" + numberOfNeighbours + "+" + hCount + "+" + formalCharge + "+" + aromaticBondCount + "+" + isIn3MemberRing + "+" + singleBondCount + "+" + doubleBondCount + "+" + tripleBondCount;
            profiles.add(profile);
        }
        double tpsa = 0.0;
        for (int profileIndex = 0; profileIndex < profiles.size(); ++profileIndex) {
            if (!map.containsKey(profiles.get(profileIndex))) continue;
            tpsa += ((Double)map.get(profiles.get(profileIndex))).doubleValue();
        }
        profiles.clear();
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(tpsa), this.getDescriptorNames());
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return true;
    }

    static {
        names = new String[]{"TopoPSA"};
    }
}

